/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree.indexinglanguage;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.indexinglanguage.Node;
import ai.vespa.schemals.parser.indexinglanguage.TokenSource;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ILUtils {
    private static Position getPositionFromOffset(TokenSource tokenSource, int offset) {
        int line = tokenSource.getLineFromOffset(offset) - 1;
        int startOfLineOffset = tokenSource.getLineStartOffset(line + 1);
        int column = offset - startOfLineOffset;
        return new Position(line, column);
    }

    public static Range getRangeFromOffsets(TokenSource tokenSource, int beginOffset, int endOffset) {
        Position begin = ILUtils.getPositionFromOffset(tokenSource, beginOffset);
        Position end = ILUtils.getPositionFromOffset(tokenSource, endOffset);
        return new Range(begin, end);
    }

    public static Range getNodeRange(Node node) {
        TokenSource tokenSource = node.getTokenSource();
        return ILUtils.getRangeFromOffsets(tokenSource, node.getBeginOffset(), node.getEndOffset());
    }

    public static void printTree(ClientLogger logger, Node node) {
        ILUtils.printTree(logger, node, 0);
    }

    public static void printTree(ClientLogger logger, Node node, Integer indent) {
        Range range = ILUtils.getNodeRange(node);
        logger.info(new String(new char[indent.intValue()]).replace("\u0000", "\t") + node.getClass().getName() + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ") - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")");
        for (Node child : node) {
            ILUtils.printTree(logger, child, indent + 1);
        }
    }
}

