/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree;

import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQLNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Range;

public abstract class Node
implements Iterable<Node> {
    private List<Node> children = new ArrayList<Node>();
    private Node parent;
    protected LanguageType language;
    protected Range range;
    protected boolean isDirty;
    protected Symbol symbol;

    protected Node(LanguageType language, Range range, boolean isDirty) {
        this.language = language;
        this.range = range;
        this.isDirty = isDirty;
    }

    public LanguageType getLanguageType() {
        return this.language;
    }

    public Range getRange() {
        return this.range;
    }

    public boolean getIsDirty() {
        return this.isDirty;
    }

    public int size() {
        return this.children.size();
    }

    public Node get(int i) {
        return this.children.get(i);
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void addChild(Node child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void addChildren(List<? extends Node> children) {
        for (Node node : children) {
            this.addChild(node);
        }
    }

    public void clearChildren() {
        for (Node child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    public Node removeChild(int i) {
        Node child = this.children.remove(i);
        child.setParent(null);
        return child;
    }

    public Node getParent(int levels) {
        if (levels == 0) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getParent(levels - 1);
    }

    public Node getParent() {
        return this.getParent(1);
    }

    public void insertChildAfter(int index, Node child) {
        this.children.add(index + 1, child);
        child.setParent(this);
    }

    public Node getPrevious() {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        if (parentIndex == 0) {
            return this.parent;
        }
        return this.parent.get(parentIndex - 1);
    }

    public Node getNext() {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        if (parentIndex == this.parent.size() - 1) {
            return this.parent.getNext();
        }
        return this.parent.get(parentIndex + 1);
    }

    public Node getSibling(int relativeIndex) {
        if (this.parent == null) {
            return null;
        }
        int parentIndex = this.parent.indexOf(this);
        if (parentIndex == -1) {
            return null;
        }
        int siblingIndex = parentIndex + relativeIndex;
        if (siblingIndex < 0 || siblingIndex >= this.parent.size()) {
            return null;
        }
        return this.parent.get(siblingIndex);
    }

    public Node getPreviousSibling() {
        return this.getSibling(-1);
    }

    public Node getNextSibling() {
        return this.getSibling(1);
    }

    public int indexOf(Node child) {
        return this.children.indexOf(child);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean hasSymbol() {
        return this.symbol != null;
    }

    public Symbol getSymbol() {
        if (!this.hasSymbol()) {
            throw new IllegalArgumentException("get Symbol called on node without a symbol!");
        }
        return this.symbol;
    }

    public void removeSymbol() {
        this.symbol = null;
    }

    public Symbol setSymbol(Symbol.SymbolType type, String fileURI, Symbol scope, String shortIdentifier) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbol = new Symbol(this, type, fileURI, scope, shortIdentifier);
        return this.symbol;
    }

    public Symbol setSymbol(Symbol.SymbolType type, String fileURI) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbol = new Symbol(this, type, fileURI);
        return this.symbol;
    }

    public Symbol setSymbol(Symbol.SymbolType type, String fileURI, Symbol scope) {
        if (this.hasSymbol()) {
            throw new IllegalArgumentException("Cannot set symbol for node: " + this.toString() + ". Already has symbol.");
        }
        this.symbol = new Symbol(this, type, fileURI, scope);
        return this.symbol;
    }

    public Symbol setSymbol(Symbol.SymbolType type, String fileURI, Optional<Symbol> scope) {
        if (scope.isPresent()) {
            this.setSymbol(type, fileURI, scope.get());
        } else {
            this.setSymbol(type, fileURI);
        }
        return this.symbol;
    }

    public abstract int getBeginOffset();

    public abstract String getText();

    public abstract Class<?> getASTClass();

    public boolean isASTInstance(Class<?> cls) {
        return this.getASTClass() == cls;
    }

    public boolean isSchemaNode() {
        return false;
    }

    public SchemaNode getSchemaNode() {
        throw new UnsupportedOperationException("Cannot get a SchemaNode from a non SchemaNode.");
    }

    public boolean isYQLNode() {
        return false;
    }

    public YQLNode getYQLNode() {
        throw new UnsupportedOperationException("Cannot get a YQLNode from a non YQLNode.");
    }

    @Override
    public Iterator<Node> iterator() {
        return new Iterator<Node>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < Node.this.children.size();
            }

            @Override
            public Node next() {
                return Node.this.children.get(this.currentIndex++);
            }
        };
    }

    public static enum LanguageType {
        SCHEMA,
        INDEXING,
        RANK_EXPRESSION,
        YQLPlus,
        GROUPING,
        CUSTOM;

    }
}

