/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.COMMA;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class InheritanceResolver {
    public static List<Diagnostic> resolveInheritances(ParseContext context) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        HashSet documentInheritanceURIs = new HashSet();
        for (SchemaNode inheritanceNode : context.unresolvedInheritanceNodes()) {
            if (inheritanceNode.getSymbol().getType() != Symbol.SymbolType.DOCUMENT) continue;
            InheritanceResolver.resolveDocumentInheritance(inheritanceNode, context, diagnostics).ifPresent(parentURI -> documentInheritanceURIs.add(parentURI));
        }
        for (SchemaNode inheritanceNode : context.unresolvedInheritanceNodes()) {
            if (inheritanceNode.getSymbol().getType() == Symbol.SymbolType.STRUCT) {
                InheritanceResolver.resolveStructInheritance(inheritanceNode, context, diagnostics);
            }
            if (inheritanceNode.getSymbol().getType() == Symbol.SymbolType.RANK_PROFILE) {
                InheritanceResolver.resolveRankProfileInheritance(inheritanceNode, context, diagnostics);
            }
            if (inheritanceNode.getSymbol().getType() != Symbol.SymbolType.DOCUMENT_SUMMARY) continue;
            InheritanceResolver.resolveDocumentSummaryInheritance(inheritanceNode, context, diagnostics);
        }
        if (context.inheritsSchemaNode() != null) {
            SchemaDocument parent;
            String inheritsSchemaName = context.inheritsSchemaNode().getText();
            Optional<Symbol> schemaSymbol = context.schemaIndex().getSchemaDefinition(inheritsSchemaName);
            if (schemaSymbol.isPresent() && (parent = context.scheduler().getSchemaDocument(schemaSymbol.get().getFileURI())) != null) {
                if (!documentInheritanceURIs.contains(parent.getFileURI())) {
                    diagnostics.add(new SchemaDiagnostic.Builder().setRange(context.inheritsSchemaNode().getRange()).setMessage("The schema document must explicitly inherit from " + inheritsSchemaName + " because the containing schema does so.").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.EXPLICITLY_INHERIT_DOCUMENT).build());
                    context.schemaIndex().getDocumentInheritanceGraph().addInherits(context.fileURI(), parent.getFileURI());
                }
                context.schemaIndex().insertSymbolReference(schemaSymbol.get(), context.inheritsSchemaNode().getSymbol());
            }
        }
        context.clearUnresolvedInheritanceNodes();
        return diagnostics;
    }

    private static void resolveStructInheritance(SchemaNode inheritanceNode, ParseContext context, List<Diagnostic> diagnostics) {
        if (inheritanceNode.getPreviousSibling() != null && inheritanceNode.getPreviousSibling().getASTClass() == COMMA.class) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Inheriting multiple structs is not supported.").setSeverity(DiagnosticSeverity.Error).build());
            return;
        }
        Node myStructDefinitionNode = inheritanceNode.getParent().getPreviousSibling();
        if (myStructDefinitionNode == null) {
            return;
        }
        if (!myStructDefinitionNode.hasSymbol()) {
            return;
        }
        Optional<Symbol> parentSymbol = context.schemaIndex().findSymbol(inheritanceNode.getSymbol());
        if (parentSymbol.isEmpty()) {
            return;
        }
        if (!context.schemaIndex().tryRegisterStructInheritance(myStructDefinitionNode.getSymbol(), parentSymbol.get())) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Cannot inherit from " + parentSymbol.get().getShortIdentifier() + " because " + parentSymbol.get().getShortIdentifier() + " inherits from this struct.").setSeverity(DiagnosticSeverity.Error).build());
        }
        Symbol structDefinitionSymbol = myStructDefinitionNode.getSymbol();
        HashMap<String, Symbol> inheritedFields = new HashMap<String, Symbol>();
        ArrayList<Symbol> myFields = new ArrayList<Symbol>();
        for (Symbol fieldSymbol : context.schemaIndex().listSymbolsInScope(structDefinitionSymbol, Symbol.SymbolType.FIELD)) {
            if (fieldSymbol.getScope().equals(structDefinitionSymbol)) {
                myFields.add(fieldSymbol);
                continue;
            }
            inheritedFields.put(fieldSymbol.getShortIdentifier(), fieldSymbol);
        }
        for (Symbol fieldSymbol : myFields) {
            if (!inheritedFields.containsKey(fieldSymbol.getShortIdentifier())) continue;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(fieldSymbol.getNode().getRange()).setMessage("struct " + myStructDefinitionNode.getText() + " cannot inherit from " + parentSymbol.get().getShortIdentifier() + " and redeclare field " + fieldSymbol.getShortIdentifier()).setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.INHERITS_STRUCT_FIELD_REDECLARED).build());
        }
    }

    private static void resolveRankProfileInheritance(SchemaNode inheritanceNode, ParseContext context, List<Diagnostic> diagnostics) {
        Node myRankProfileDefinitionNode = inheritanceNode.getParent().getPreviousSibling();
        String inheritedIdentifier = inheritanceNode.getText();
        if (myRankProfileDefinitionNode == null) {
            return;
        }
        if (!myRankProfileDefinitionNode.hasSymbol() || myRankProfileDefinitionNode.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
            return;
        }
        List<Symbol> parentSymbols = context.schemaIndex().findSymbols(inheritanceNode.getSymbol());
        if (parentSymbols.isEmpty() || inheritedIdentifier.equals("default") && myRankProfileDefinitionNode.getSymbol().getShortIdentifier().equals("default")) {
            if (inheritedIdentifier.equals("default")) {
                inheritanceNode.setSymbolStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
                return;
            }
            return;
        }
        if (parentSymbols.size() > 1 && !parentSymbols.get(0).fileURIEquals(context.fileURI())) {
            Object note = "\nNote:";
            for (Symbol symbol : parentSymbols) {
                note = (String)note + "\nDefined in " + FileUtils.fileNameFromPath(symbol.getFileURI());
            }
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage(inheritedIdentifier + " is ambiguous in this context. " + (String)note).setSeverity(DiagnosticSeverity.Warning).build());
        }
        Symbol parentSymbol = parentSymbols.get(0);
        Symbol definitionSymbol = myRankProfileDefinitionNode.getSymbol();
        if (!InheritanceResolver.checkRankProfileInheritanceCollisions(context, definitionSymbol, parentSymbol, inheritanceNode, diagnostics)) {
            return;
        }
        if (!context.schemaIndex().tryRegisterRankProfileInheritance(definitionSymbol, parentSymbol)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Cannot inherit from " + parentSymbol.getShortIdentifier() + " because " + parentSymbol.getShortIdentifier() + " inherits from this rank profile. ").setSeverity(DiagnosticSeverity.Error).build());
            return;
        }
    }

    private static boolean checkRankProfileInheritanceCollisions(ParseContext context, Symbol rankProfileDefinitionSymbol, Symbol inheritanceCandidate, SchemaNode inheritanceNode, List<Diagnostic> diagnostics) {
        HashMap<String, Symbol> functionDefinitionsBeforeInheritance = new HashMap<String, Symbol>();
        for (Symbol symbol : context.schemaIndex().listSymbolsInScope(rankProfileDefinitionSymbol, Symbol.SymbolType.FUNCTION)) {
            if (symbol.getScope().equals(rankProfileDefinitionSymbol)) continue;
            functionDefinitionsBeforeInheritance.put(symbol.getShortIdentifier(), symbol.getScope());
        }
        List<Symbol> newInheritedFunctions = context.schemaIndex().listSymbolsInScope(inheritanceCandidate, Symbol.SymbolType.FUNCTION);
        boolean success = true;
        for (Symbol parentFunction : newInheritedFunctions) {
            if (!functionDefinitionsBeforeInheritance.containsKey(parentFunction.getShortIdentifier())) continue;
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Cannot inherit from " + inheritanceNode.getText() + " because " + inheritanceNode.getText() + " defines function " + parentFunction.getShortIdentifier() + " which is already defined in " + ((Symbol)functionDefinitionsBeforeInheritance.get(parentFunction.getShortIdentifier())).getShortIdentifier()).setSeverity(DiagnosticSeverity.Error).build());
            success = false;
        }
        return success;
    }

    private static Optional<String> resolveDocumentInheritance(SchemaNode inheritanceNode, ParseContext context, List<Diagnostic> diagnostics) {
        String schemaDocumentName = inheritanceNode.getText();
        Optional<Symbol> symbol = context.schemaIndex().getSchemaDefinition(schemaDocumentName);
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        if (!context.schemaIndex().tryRegisterDocumentInheritance(context.fileURI(), symbol.get().getFileURI())) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Cannot inherit from " + schemaDocumentName + " because " + schemaDocumentName + " inherits from this document.").setSeverity(DiagnosticSeverity.Error).build());
            return Optional.empty();
        }
        inheritanceNode.setSymbolStatus(Symbol.SymbolStatus.REFERENCE);
        context.schemaIndex().insertSymbolReference(symbol.get(), inheritanceNode.getSymbol());
        return Optional.of(symbol.get().getFileURI());
    }

    private static void resolveDocumentSummaryInheritance(SchemaNode inheritanceNode, ParseContext context, List<Diagnostic> diagnostics) {
        Node myDocSummaryDefinitionNode = inheritanceNode.getParent().getPreviousSibling();
        if (myDocSummaryDefinitionNode == null) {
            return;
        }
        if (!myDocSummaryDefinitionNode.hasSymbol()) {
            return;
        }
        Optional<Symbol> parentSymbol = context.schemaIndex().findSymbol(inheritanceNode.getSymbol());
        if (parentSymbol.isEmpty()) {
            return;
        }
        if (!context.schemaIndex().tryRegisterDocumentSummaryInheritance(myDocSummaryDefinitionNode.getSymbol(), parentSymbol.get())) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(inheritanceNode.getRange()).setMessage("Cannot inherit from " + parentSymbol.get().getShortIdentifier() + " because " + parentSymbol.get().getShortIdentifier() + " inherits from this document summary.").setSeverity(DiagnosticSeverity.Error).build());
        }
    }
}

