/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.index;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.InheritanceGraph;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.annotationElm;
import ai.vespa.schemals.parser.ast.annotationOutside;
import ai.vespa.schemals.parser.ast.constantName;
import ai.vespa.schemals.parser.ast.documentElm;
import ai.vespa.schemals.parser.ast.documentSummary;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.fieldSetElm;
import ai.vespa.schemals.parser.ast.functionElm;
import ai.vespa.schemals.parser.ast.inputName;
import ai.vespa.schemals.parser.ast.namedDocument;
import ai.vespa.schemals.parser.ast.onnxModel;
import ai.vespa.schemals.parser.ast.rankProfile;
import ai.vespa.schemals.parser.ast.rootSchema;
import ai.vespa.schemals.parser.ast.structDefinitionElm;
import ai.vespa.schemals.parser.ast.structFieldDefinition;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SchemaIndex {
    public static final HashMap<Class<?>, Symbol.SymbolType> IDENTIFIER_TYPE_MAP = new HashMap<Class<?>, Symbol.SymbolType>(){
        {
            this.put(annotationElm.class, Symbol.SymbolType.ANNOTATION);
            this.put(annotationOutside.class, Symbol.SymbolType.ANNOTATION);
            this.put(rootSchema.class, Symbol.SymbolType.SCHEMA);
            this.put(documentElm.class, Symbol.SymbolType.DOCUMENT);
            this.put(namedDocument.class, Symbol.SymbolType.DOCUMENT);
            this.put(fieldElm.class, Symbol.SymbolType.FIELD);
            this.put(fieldSetElm.class, Symbol.SymbolType.FIELDSET);
            this.put(structDefinitionElm.class, Symbol.SymbolType.STRUCT);
            this.put(structFieldDefinition.class, Symbol.SymbolType.FIELD);
            this.put(functionElm.class, Symbol.SymbolType.FUNCTION);
            this.put(inputName.class, Symbol.SymbolType.QUERY_INPUT);
            this.put(constantName.class, Symbol.SymbolType.RANK_CONSTANT);
            this.put(onnxModel.class, Symbol.SymbolType.ONNX_MODEL);
        }
    };
    public static final HashMap<Class<?>, Symbol.SymbolType> IDENTIFIER_WITH_DASH_TYPE_MAP = new HashMap<Class<?>, Symbol.SymbolType>(){
        {
            this.put(rankProfile.class, Symbol.SymbolType.RANK_PROFILE);
            this.put(documentSummary.class, Symbol.SymbolType.DOCUMENT_SUMMARY);
        }
    };
    private ClientLogger logger;
    private FieldIndex fieldIndex;
    private Map<Symbol.SymbolType, List<Symbol>> symbolDefinitions;
    private Map<Symbol, List<Symbol>> symbolReferences;
    private Map<Symbol, Symbol> definitionOfReference;
    private Set<Symbol> unresolvedSymbols;
    private InheritanceGraph<String> documentInheritanceGraph;
    private InheritanceGraph<Symbol> structInheritanceGraph;
    private InheritanceGraph<Symbol> rankProfileInheritanceGraph;
    private InheritanceGraph<Symbol> documentSummaryInheritanceGraph;
    private InheritanceGraph<Symbol> documentReferenceGraph;

    public SchemaIndex(ClientLogger logger) {
        this.logger = logger;
        this.documentInheritanceGraph = new InheritanceGraph();
        this.structInheritanceGraph = new InheritanceGraph();
        this.rankProfileInheritanceGraph = new InheritanceGraph();
        this.documentSummaryInheritanceGraph = new InheritanceGraph();
        this.documentReferenceGraph = new InheritanceGraph();
        this.symbolDefinitions = new HashMap<Symbol.SymbolType, List<Symbol>>();
        this.symbolReferences = new HashMap<Symbol, List<Symbol>>();
        this.definitionOfReference = new HashMap<Symbol, Symbol>();
        this.unresolvedSymbols = new HashSet<Symbol>();
        for (Symbol.SymbolType type : Symbol.SymbolType.values()) {
            this.symbolDefinitions.put(type, new ArrayList());
        }
        this.fieldIndex = new FieldIndex(logger, this);
    }

    public FieldIndex fieldIndex() {
        return this.fieldIndex;
    }

    public InheritanceGraph<String> getDocumentInheritanceGraph() {
        return this.documentInheritanceGraph;
    }

    public InheritanceGraph<Symbol> getRankProfileInheritanceGraph() {
        return this.rankProfileInheritanceGraph;
    }

    public InheritanceGraph<Symbol> getDocumentReferenceGraph() {
        return this.documentReferenceGraph;
    }

    public void clearDocument(String fileURI) {
        URI fileURIURI = URI.create(fileURI);
        for (Map.Entry<Symbol, List<Symbol>> entry : this.symbolReferences.entrySet()) {
            List<Symbol> references = entry.getValue();
            ArrayList<Symbol> replacedReferences = new ArrayList<Symbol>();
            for (Symbol symbol2 : references) {
                if (symbol2.fileURIEquals(fileURIURI)) {
                    this.definitionOfReference.remove(symbol2);
                    continue;
                }
                replacedReferences.add(symbol2);
            }
            entry.setValue(replacedReferences);
        }
        for (List list : this.symbolDefinitions.values()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Symbol symbol3 = (Symbol)list.get(i);
                if (!symbol3.fileURIEquals(fileURIURI)) continue;
                this.symbolReferences.remove(symbol3);
                this.structInheritanceGraph.clearInheritsList(symbol3);
                this.rankProfileInheritanceGraph.clearInheritsList(symbol3);
                this.documentSummaryInheritanceGraph.clearInheritsList(symbol3);
                this.documentReferenceGraph.clearInheritsList(symbol3);
                list.remove(i);
            }
        }
        this.unresolvedSymbols.removeIf(symbol -> symbol.fileURIEquals(fileURIURI));
        this.fieldIndex.clearFieldsByURI(fileURIURI);
        if (fileURI.endsWith(".sd")) {
            this.documentInheritanceGraph.clearInheritsList(fileURI);
            this.documentInheritanceGraph.createNodeIfNotExists(fileURI);
        }
    }

    public Optional<Symbol> findSymbol(Symbol symbol) {
        return this.findSymbol(symbol.getScope(), symbol.getType(), symbol.getShortIdentifier());
    }

    public Optional<Symbol> findSymbol(Symbol scope, Symbol.SymbolType type, String shortIdentifier) {
        List<Symbol> results = this.findSymbols(scope, type, shortIdentifier);
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(results.get(0));
    }

    public Optional<Symbol> findSymbolInScope(Symbol symbol) {
        return this.findSymbolInScope(symbol.getScope(), symbol.getType(), symbol.getShortIdentifier());
    }

    public Optional<Symbol> findSymbolInScope(Symbol scope, Symbol.SymbolType type, String shortIdentifier) {
        List<Symbol> results = this.findSymbolsInScope(scope, type, shortIdentifier);
        if (results.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(results.get(0));
    }

    public List<Symbol> findSymbols(Symbol symbol) {
        return this.findSymbols(symbol.getScope(), symbol.getType(), symbol.getShortIdentifier());
    }

    public List<Symbol> findSymbols(Symbol scope, Symbol.SymbolType type, String shortIdentifier) {
        if (type == Symbol.SymbolType.SCHEMA || type == Symbol.SymbolType.DOCUMENT) {
            Symbol.SymbolType firstCheck = type == Symbol.SymbolType.SCHEMA ? Symbol.SymbolType.SCHEMA : Symbol.SymbolType.DOCUMENT;
            List<Symbol> schemaDefinitions = this.symbolDefinitions.get((Object)firstCheck).stream().filter(symbolDefinition -> symbolDefinition.getShortIdentifier().equals(shortIdentifier)).toList();
            if (!schemaDefinitions.isEmpty()) {
                return schemaDefinitions;
            }
            return this.symbolDefinitions.get((Object)(firstCheck == Symbol.SymbolType.SCHEMA ? Symbol.SymbolType.DOCUMENT : Symbol.SymbolType.SCHEMA)).stream().filter(symbolDefinition -> symbolDefinition.getShortIdentifier().equals(shortIdentifier)).toList();
        }
        while (scope != null) {
            List<Symbol> result = this.findSymbolsInScope(scope, type, shortIdentifier);
            if (!result.isEmpty()) {
                return result;
            }
            scope = scope.getScope();
        }
        return new ArrayList<Symbol>();
    }

    private Optional<Symbol> findSymbolInConcreteScope(Symbol scope, Symbol.SymbolType type, String shortIdentifier) {
        for (Symbol symbolDefinition : this.symbolDefinitions.get((Object)type)) {
            if (!symbolDefinition.getShortIdentifier().equals(shortIdentifier) || !scope.equals(symbolDefinition.getScope())) continue;
            return Optional.of(symbolDefinition);
        }
        return Optional.empty();
    }

    public List<Symbol> findSymbolsInScope(Symbol scope, Symbol.SymbolType type, String shortIdentifier) {
        if (scope.getType() == Symbol.SymbolType.RANK_PROFILE) {
            return this.rankProfileInheritanceGraph.findFirstMatches(scope, rankProfileDefinitionSymbol -> {
                Optional<Symbol> definedInScope = this.findSymbolInConcreteScope((Symbol)rankProfileDefinitionSymbol, type, shortIdentifier);
                if (definedInScope.isEmpty()) {
                    return null;
                }
                return definedInScope;
            }).stream().map(result -> (Symbol)((Optional)result.result).get()).toList();
        }
        if (scope.getType() == Symbol.SymbolType.STRUCT) {
            return this.structInheritanceGraph.findFirstMatches(scope, rankProfileDefinitionSymbol -> {
                Optional<Symbol> definedInScope = this.findSymbolInConcreteScope((Symbol)rankProfileDefinitionSymbol, type, shortIdentifier);
                if (definedInScope.isEmpty()) {
                    return null;
                }
                return definedInScope;
            }).stream().map(result -> (Symbol)((Optional)result.result).get()).toList();
        }
        if (scope.getType() == Symbol.SymbolType.DOCUMENT || scope.getType() == Symbol.SymbolType.SCHEMA) {
            return this.documentInheritanceGraph.findFirstMatches(scope.getFileURI(), ancestorURI -> {
                List<Symbol> match = this.symbolDefinitions.get((Object)type).stream().filter(symbolDefinition -> symbolDefinition.getScope() != null && (symbolDefinition.getScope().getType() == Symbol.SymbolType.SCHEMA || symbolDefinition.getScope().getType() == Symbol.SymbolType.DOCUMENT) && symbolDefinition.getShortIdentifier().equals(shortIdentifier) && symbolDefinition.getScope().getFileURI().equals(ancestorURI)).toList();
                if (match.isEmpty()) {
                    return null;
                }
                return Optional.of(match.get(0));
            }).stream().map(result -> (Symbol)((Optional)result.result).get()).toList();
        }
        Optional<Symbol> symbol = this.findSymbolInConcreteScope(scope, type, shortIdentifier);
        ArrayList<Symbol> result2 = new ArrayList<Symbol>();
        if (symbol.isPresent()) {
            result2.add(symbol.get());
        }
        return result2;
    }

    public List<Symbol> findSymbolsInScope(Symbol reference) {
        return this.findSymbolsInScope(reference.getScope(), reference.getType(), reference.getFileURI());
    }

    public boolean isInScope(Symbol symbol, Symbol scope) {
        if (scope == null) {
            return true;
        }
        if (scope.getType() == Symbol.SymbolType.RANK_PROFILE) {
            return !this.rankProfileInheritanceGraph.findFirstMatches(scope, rankProfileDefinitionSymbol -> {
                if (rankProfileDefinitionSymbol.equals(symbol.getScope())) {
                    return true;
                }
                return null;
            }).isEmpty();
        }
        if (scope.getType() == Symbol.SymbolType.STRUCT) {
            return !this.structInheritanceGraph.findFirstMatches(scope, structDefinitionSymbol -> {
                if (structDefinitionSymbol.equals(symbol.getScope())) {
                    return true;
                }
                return null;
            }).isEmpty();
        }
        if (!(symbol.getScope() != null && symbol.getScope().getType() != Symbol.SymbolType.SCHEMA && symbol.getScope().getType() != Symbol.SymbolType.DOCUMENT || scope.getType() != Symbol.SymbolType.SCHEMA && scope.getType() != Symbol.SymbolType.DOCUMENT)) {
            return !this.documentInheritanceGraph.findFirstMatches(scope.getFileURI(), ancestorURI -> {
                if (symbol.getFileURI().equals(ancestorURI)) {
                    return true;
                }
                return null;
            }).isEmpty();
        }
        return scope.equals(symbol.getScope());
    }

    public Optional<Symbol> getSymbolDefinition(Symbol reference) {
        if (reference.getStatus() == Symbol.SymbolStatus.DEFINITION) {
            return Optional.of(reference);
        }
        return Optional.ofNullable(this.definitionOfReference.get(reference));
    }

    public Optional<Symbol> getNextSymbolDefinition(Symbol reference) {
        return Optional.ofNullable(this.definitionOfReference.get(reference));
    }

    public Optional<Symbol> getFirstSymbolDefinition(Symbol symbol) {
        while (this.definitionOfReference.get(symbol) != null) {
            symbol = this.definitionOfReference.get(symbol);
        }
        if (symbol.getStatus() == Symbol.SymbolStatus.DEFINITION) {
            return Optional.of(symbol);
        }
        return Optional.empty();
    }

    public List<Symbol> getSymbolReferences(Symbol definition) {
        List<Symbol> results = this.symbolReferences.get(definition);
        if (results == null) {
            return new ArrayList<Symbol>();
        }
        return List.copyOf(results);
    }

    public Optional<Symbol> getSchemaDefinition(String shortIdentifier) {
        List<Symbol> list = this.symbolDefinitions.get((Object)Symbol.SymbolType.SCHEMA);
        for (Symbol symbol : list) {
            if (!symbol.getShortIdentifier().equals(shortIdentifier)) continue;
            return Optional.of(symbol);
        }
        list = this.symbolDefinitions.get((Object)Symbol.SymbolType.DOCUMENT);
        for (Symbol symbol : list) {
            if (!symbol.getShortIdentifier().equals(shortIdentifier)) continue;
            return Optional.of(symbol);
        }
        return Optional.empty();
    }

    public List<Symbol> getSymbolsByType(Symbol.SymbolType type) {
        return this.symbolDefinitions.get((Object)type);
    }

    public void insertSymbolDefinition(Symbol symbol) {
        List<Symbol> list = this.symbolDefinitions.get((Object)symbol.getType());
        list.add(symbol);
        this.symbolReferences.put(symbol, new ArrayList());
        if (symbol.getType() == Symbol.SymbolType.FIELD) {
            this.fieldIndex.insertFieldDefinition(symbol);
        }
    }

    public void insertSymbolReference(Symbol definition, Symbol reference) {
        List<Symbol> list = this.symbolReferences.get(definition);
        if (list == null) {
            throw new IllegalArgumentException("Could not insert symbol reference" + reference + " before the definition is inserted");
        }
        this.definitionOfReference.put(reference, definition);
        list.add(reference);
        if (reference.getType() == Symbol.SymbolType.RANK_PROFILE && reference.getScope() != null) {
            this.tryRegisterRankProfileInheritance(reference.getScope(), definition);
        }
        if (reference.getType() == Symbol.SymbolType.STRUCT && reference.getScope() != null) {
            this.tryRegisterStructInheritance(reference.getScope(), definition);
        }
        if (reference.getType() == Symbol.SymbolType.DOCUMENT_SUMMARY && reference.getScope() != null) {
            this.tryRegisterDocumentSummaryInheritance(reference.getScope(), definition);
        }
    }

    public void deleteSymbolReference(Symbol symbol) {
        List<Symbol> references;
        Symbol definition = this.definitionOfReference.remove(symbol);
        if (definition != null && (references = this.symbolReferences.get(definition)) != null) {
            references.remove(symbol);
        }
    }

    public boolean tryRegisterDocumentInheritance(String childURI, String parentURI) {
        return this.documentInheritanceGraph.addInherits(childURI, parentURI);
    }

    public boolean tryRegisterStructInheritance(Symbol childSymbol, Symbol parentSymbol) {
        return this.structInheritanceGraph.addInherits(childSymbol, parentSymbol);
    }

    public boolean tryRegisterRankProfileInheritance(Symbol childSymbol, Symbol parentSymbol) {
        return this.rankProfileInheritanceGraph.addInherits(childSymbol, parentSymbol);
    }

    public boolean tryRegisterDocumentSummaryInheritance(Symbol childSymbol, Symbol parentSymbol) {
        return this.documentSummaryInheritanceGraph.addInherits(childSymbol, parentSymbol);
    }

    public boolean tryRegisterDocumentReference(Symbol childSymbol, Symbol parentSymbol) {
        return this.documentReferenceGraph.addInherits(childSymbol, parentSymbol);
    }

    public List<Symbol> listSymbolsInScope(Symbol scope, Symbol.SymbolType type) {
        return this.listSymbolsInScope(scope, EnumSet.of(type));
    }

    public List<Symbol> listSymbolsInScope(Symbol scope, EnumSet<Symbol.SymbolType> types) {
        ArrayList<Symbol> ret = new ArrayList<Symbol>();
        for (Symbol.SymbolType type : types) {
            ret.addAll(this.symbolDefinitions.get((Object)type).stream().filter(symbol -> this.isInScope((Symbol)symbol, scope)).toList());
        }
        return ret;
    }

    public void addUnresolvedSymbol(Symbol unresolvedSymbol) {
        this.unresolvedSymbols.add(unresolvedSymbol);
    }

    public List<Symbol> getUnresolvedSymbols() {
        this.unresolvedSymbols.removeIf(symbol -> this.getSymbolDefinition((Symbol)symbol).isPresent());
        return List.copyOf(this.unresolvedSymbols);
    }

    public void dumpIndex() {
        this.logger.info(" === SYMBOL DEFINITIONS === ");
        for (Map.Entry<Symbol.SymbolType, List<Symbol>> entry : this.symbolDefinitions.entrySet()) {
            this.logger.info("TYPE: " + (Object)((Object)entry.getKey()));
            for (Symbol symbol : entry.getValue()) {
                this.logger.info("    " + symbol);
            }
        }
        this.logger.info("\n === SYMBOL DEFINITION REFERENCES === ");
        for (Map.Entry<Object, List<Symbol>> entry : this.symbolReferences.entrySet()) {
            this.logger.info(entry.getKey());
            for (Symbol symbol : entry.getValue()) {
                this.logger.info("    " + symbol);
            }
        }
        this.logger.info("\n === REFERENCES TO DEFINITIONS ===");
        for (Map.Entry<Object, Object> entry : this.definitionOfReference.entrySet()) {
            String toPrint = String.format("%-50s -> %s", entry.getKey(), entry.getValue());
            this.logger.info(toPrint);
        }
        this.logger.info("\n === DOCUMENT INHERITANCE === ");
        this.documentInheritanceGraph.dumpAllEdges(this.logger);
        this.logger.info(" === STRUCT INHERITANCE === ");
        this.structInheritanceGraph.dumpAllEdges(this.logger);
        this.logger.info(" === RANK PROFILE INHERITANCE === ");
        this.rankProfileInheritanceGraph.dumpAllEdges(this.logger);
        this.logger.info(" === DOCUMENT REFERENCES === ");
        this.documentReferenceGraph.dumpAllEdges(this.logger);
        this.logger.info(" === FIELD INDEX === ");
        this.fieldIndex.dumpIndex();
    }
}

