/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.vespa.parser;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.vespa.parser.CharStream;
import ai.vespa.rankingexpression.importer.vespa.parser.ModelParserConstants;
import ai.vespa.rankingexpression.importer.vespa.parser.ModelParserTokenManager;
import ai.vespa.rankingexpression.importer.vespa.parser.ParseException;
import ai.vespa.rankingexpression.importer.vespa.parser.SimpleCharStream;
import ai.vespa.rankingexpression.importer.vespa.parser.Token;
import com.yahoo.io.IOUtils;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ModelParser
implements ModelParserConstants {
    private ImportedModel model;
    public ModelParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public ModelParser(String input, ImportedModel model) {
        this(new SimpleCharStream(input), model);
    }

    public ModelParser(SimpleCharStream input, ImportedModel model) {
        this(input);
        this.model = model;
    }

    public final void model() throws ParseException {
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(16);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        String name = this.identifier();
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(11);
        this.modelContent();
        this.jj_consume_token(12);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        if (!this.model.name().endsWith(name)) {
            throw new IllegalArgumentException("Unexpected model name '" + this.model.name() + "': Model '" + name + "' must be saved in a file named '" + name + ".model'");
        }
    }

    public final void modelContent() throws ParseException {
        block11: {
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 16: 
                    case 17: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        continue block10;
                    }
                    case 16: 
                    case 17: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 35: {
                        this.input();
                        continue block10;
                    }
                    case 30: {
                        this.constants();
                        continue block10;
                    }
                    case 29: {
                        this.largeConstant();
                        continue block10;
                    }
                    case 6: {
                        this.function();
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void input() throws ParseException {
        String name = this.identifier();
        this.jj_consume_token(13);
        TensorType type = this.tensorType("Input parameter '" + name + "'");
        this.model.input(name, type);
    }

    public final void function() throws ParseException {
        ArrayList<String> parameters = new ArrayList<String>();
        this.jj_consume_token(6);
        String name = this.identifier();
        this.jj_consume_token(41);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                String parameter = this.identifier();
                parameters.add(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 15: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(15);
                    parameter = this.identifier();
                    parameters.add(parameter);
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(42);
        this.lbrace();
        String expression = this.expression();
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(12);
        this.model.expression(name, expression);
    }

    public final void constants() throws ParseException {
        this.jj_consume_token(30);
        this.jj_consume_token(11);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: 
                case 31: 
                case 32: 
                case 33: 
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block14;
                }
            }
            String name = this.identifier();
            this.jj_consume_token(13);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: {
                    this.constantDouble(name);
                    break;
                }
                case 7: {
                    this.constantTensor(name);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(12);
    }

    public final void constantDouble(String name) throws ParseException {
        Token value = this.jj_consume_token(35);
        this.model.smallConstant(name, Tensor.from((double)Double.parseDouble(value.image)));
    }

    public final void constantTensor(String name) throws ParseException {
        TensorType type = this.tensorType("constant '" + name + "'");
        Token value = this.jj_consume_token(8);
        this.model.smallConstant(name, Tensor.from((TensorType)type, (String)value.image.substring(1)));
    }

    public final String constantTensorErrorMessage(String model, String constantTensorName) throws ParseException {
        return "For constant tensor '" + constantTensorName + "' in model '" + model + "'";
    }

    public final String tensorValue() throws ParseException {
        String tensor;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                tensor = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                tensor = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tensor;
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(7);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void largeConstant() throws ParseException {
        this.jj_consume_token(29);
        String name = this.identifier();
        this.lbrace();
        Tensor value = this.largeConstantBody(name);
        this.jj_consume_token(12);
        this.model.largeConstant(name, value);
    }

    public final Tensor largeConstantBody(String name) throws ParseException {
        String path = null;
        TensorType type = null;
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    this.jj_consume_token(13);
                    path = this.filePath();
                    break;
                }
                case 17: {
                    this.jj_consume_token(17);
                    this.jj_consume_token(13);
                    type = this.tensorType("Constant '" + name + "'");
                    break;
                }
                case 5: {
                    this.jj_consume_token(5);
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 17: 
                case 31: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[15] = this.jj_gen;
        try {
            return JsonFormat.decode((TensorType)type, (byte[])IOUtils.readFileBytes((File)this.model.relativeFile(path, "constant '" + name + "'")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read constant '" + name + "'", e);
        }
    }

    public final String filePath() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String uriPath() throws ParseException {
        this.jj_consume_token(39);
        return this.token.image;
    }

    public final String expression() throws ParseException {
        String exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                exp = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                exp = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(11);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 32, 32, 32, -536674208, -536674208, 32768, -2147287040, 32, 32, -2147287040, 128, 32, 1536, -2147352544, -2147352544, 0, 786432, -2147287040, 32, 32};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 11, 11, 0, 11, 0, 0, 11, 8, 0, 0, 0, 0, 50, 0, 11, 0, 0};
    }

    public ModelParser(CharStream stream) {
        this.token_source = new ModelParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ModelParser(ModelParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ModelParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[43];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 43; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ModelParser.jj_la1_init_0();
        ModelParser.jj_la1_init_1();
    }
}

