/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import com.yahoo.log.LogLevel;
import com.yahoo.logserver.handlers.LogHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Flusher
extends Thread {
    private static final Logger log = Logger.getLogger(Flusher.class.getName());
    private static final Flusher instance;
    private static final List<WeakReference<LogHandler>> logHandlers;

    Flusher() {
        super("flusher");
    }

    public static synchronized void register(LogHandler logHandler) {
        logHandlers.add(new WeakReference<LogHandler>(logHandler));
    }

    @Override
    public synchronized void run() {
        try {
            while (!this.isInterrupted()) {
                Thread.sleep(2000L);
                Iterator<WeakReference<LogHandler>> it = logHandlers.iterator();
                while (it.hasNext()) {
                    WeakReference<LogHandler> r = it.next();
                    LogHandler h = (LogHandler)r.get();
                    if (h == null) {
                        it.remove();
                    } else {
                        h.flush();
                    }
                    if (!log.isLoggable((Level)LogLevel.DEBUG)) continue;
                    log.log((Level)LogLevel.DEBUG, "Flushing " + h);
                }
            }
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "flusher was interrupted", e);
        }
    }

    static {
        logHandlers = new ArrayList<WeakReference<LogHandler>>();
        instance = new Flusher();
        instance.start();
    }
}

