/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.logserver.protocol;

import ai.vespa.logserver.protocol.ProtobufSerialization;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Value;
import com.yahoo.logserver.LogDispatcher;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveLogMessagesMethod {
    static final String METHOD_NAME = "vespa.logserver.archiveLogMessages";
    private static final Logger log = Logger.getLogger(ArchiveLogMessagesMethod.class.getName());
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final LogDispatcher logDispatcher;
    private final Method method;

    public ArchiveLogMessagesMethod(LogDispatcher logDispatcher) {
        this.logDispatcher = logDispatcher;
        this.method = new Method(METHOD_NAME, "bix", "bix", this::log).methodDesc("Archive log messages").paramDesc(0, "compressionType", "Compression type (0=raw)").paramDesc(1, "uncompressedSize", "Uncompressed size").paramDesc(2, "logRequest", "Log request encoded with protobuf").returnDesc(0, "compressionType", "Compression type (0=raw)").returnDesc(1, "uncompressedSize", "Uncompressed size").returnDesc(2, "logResponse", "Log response encoded with protobuf");
    }

    public Method methodDefinition() {
        return this.method;
    }

    private void log(Request rpcRequest) {
        rpcRequest.detach();
        this.executor.execute(new ArchiveLogMessagesTask(rpcRequest, this.logDispatcher));
    }

    private static class ArchiveLogMessagesTask
    implements Runnable {
        final Request rpcRequest;
        final LogDispatcher logDispatcher;

        ArchiveLogMessagesTask(Request rpcRequest, LogDispatcher logDispatcher) {
            this.rpcRequest = rpcRequest;
            this.logDispatcher = logDispatcher;
        }

        @Override
        public void run() {
            try {
                byte[] logRequestPayload;
                byte compressionType = this.rpcRequest.parameters().get(0).asInt8();
                if (compressionType != 0) {
                    this.rpcRequest.setError(111, "Invalid compression type: " + compressionType);
                    this.rpcRequest.returnRequest();
                    return;
                }
                int uncompressedSize = this.rpcRequest.parameters().get(1).asInt32();
                if (uncompressedSize != (logRequestPayload = this.rpcRequest.parameters().get(2).asData()).length) {
                    this.rpcRequest.setError(111, String.format("Invalid uncompressed size: got %d while data is of size %d ", uncompressedSize, logRequestPayload.length));
                    this.rpcRequest.returnRequest();
                    return;
                }
                this.logDispatcher.handle(ProtobufSerialization.fromLogRequest(logRequestPayload));
                this.logDispatcher.flush();
                this.rpcRequest.returnValues().add((Value)new Int8Value(0));
                byte[] responsePayload = ProtobufSerialization.toLogResponse();
                this.rpcRequest.returnValues().add((Value)new Int32Value(responsePayload.length));
                this.rpcRequest.returnValues().add((Value)new DataValue(responsePayload));
                this.rpcRequest.returnRequest();
            }
            catch (Exception e) {
                String errorMessage = "Failed to handle log request: " + e.getMessage();
                log.log(Level.WARNING, e, () -> errorMessage);
                this.rpcRequest.setError(111, errorMessage);
                this.rpcRequest.returnRequest();
            }
        }
    }
}

