/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.net;

import com.yahoo.io.Connection;
import com.yahoo.io.ConnectionFactory;
import com.yahoo.io.Listener;
import com.yahoo.logserver.LogDispatcher;
import com.yahoo.logserver.net.LogConnection;
import com.yahoo.logserver.net.control.Levels;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConnectionFactory
implements ConnectionFactory {
    private static final Logger log = Logger.getLogger(LogConnectionFactory.class.getName());
    private final LogDispatcher dispatcher;
    private final Levels defaultLogLevels;

    public LogConnectionFactory(LogDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.defaultLogLevels = Levels.parse(System.getProperty("logserver.default.loglevels", ""));
    }

    public Connection newConnection(SocketChannel socket, Listener listener) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("New connection: " + socket);
        }
        return new LogConnection(socket, listener, this.dispatcher, (Levels)this.defaultLogLevels.clone());
    }
}

