/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import com.yahoo.io.SelectLoopHook;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.LogHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogDispatcher
implements LogHandler,
SelectLoopHook {
    private static final Logger log = Logger.getLogger(LogDispatcher.class.getName());
    private final List<LogHandler> handlers = new CopyOnWriteArrayList<LogHandler>();
    private final AtomicInteger messageCount = new AtomicInteger(0);
    private final AtomicBoolean batchedMode = new AtomicBoolean(false);
    private final int batchSize = 5000;
    private final AtomicBoolean hasBeenShutDown = new AtomicBoolean(false);
    private List<LogMessage> currentBatchList = null;

    @Override
    public void handle(LogMessage msg) {
        if (msg == null) {
            throw new NullPointerException("LogMessage was null");
        }
        if (this.batchedMode.get()) {
            this.addToBatch(msg);
        } else {
            this.send(msg);
        }
        this.messageCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBatch(LogMessage msg) {
        List<LogMessage> toSend = null;
        LogDispatcher logDispatcher = this;
        synchronized (logDispatcher) {
            if (this.currentBatchList == null) {
                this.currentBatchList = new ArrayList<LogMessage>(5000);
                this.currentBatchList.add(msg);
                return;
            }
            this.currentBatchList.add(msg);
            if (this.currentBatchList.size() == 5000) {
                toSend = this.stealBatch();
            }
        }
        this.flushBatch(toSend);
    }

    private void send(List<LogMessage> messages) {
        for (LogHandler ht : this.handlers) {
            ht.handle(messages);
        }
    }

    private void send(LogMessage message) {
        for (LogHandler ht : this.handlers) {
            ht.handle(message);
        }
    }

    private void flushBatch(List<LogMessage> todo) {
        if (todo == null) {
            return;
        }
        this.send(todo);
    }

    @Override
    public void handle(List<LogMessage> messages) {
        throw new IllegalStateException("method not supported");
    }

    public void setBatchedMode(boolean batchedMode) {
        this.batchedMode.set(batchedMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogMessage> stealBatch() {
        List<LogMessage> toSend = null;
        LogDispatcher logDispatcher = this;
        synchronized (logDispatcher) {
            toSend = this.currentBatchList;
            this.currentBatchList = null;
        }
        return toSend;
    }

    @Override
    public void flush() {
        if (this.batchedMode.get()) {
            this.flushBatch(this.stealBatch());
        }
        for (LogHandler h : this.handlers) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Flushing " + h.toString());
            }
            h.flush();
        }
    }

    @Override
    public void close() {
        if (this.hasBeenShutDown.getAndSet(true)) {
            throw new IllegalStateException("Shutdown already in progress");
        }
        for (LogHandler ht : this.handlers) {
            if (!(ht instanceof Thread)) continue;
            log.fine("Stopping " + ht);
            ((Thread)((Object)ht)).interrupt();
        }
        this.handlers.clear();
        log.log((Level)LogLevel.DEBUG, "Logdispatcher shut down.  Handled " + this.messageCount + " messages");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLogHandler(LogHandler ht) {
        if (this.hasBeenShutDown.get()) {
            throw new IllegalStateException("Tried to register LogHandler on LogDispatcher which was shut down");
        }
        LogDispatcher logDispatcher = this;
        synchronized (logDispatcher) {
            if (this.handlers.contains(ht)) {
                log.warning("LogHandler was already registered: " + ht);
                return;
            }
            this.handlers.add(ht);
        }
        if (ht instanceof Thread && !((Thread)((Object)ht)).isAlive()) {
            ((Thread)((Object)ht)).start();
        }
        log.fine("Added (and possibly started) LogHandler " + ht);
    }

    public LogHandler[] getLogHandlers() {
        LogHandler[] h = new LogHandler[this.handlers.size()];
        return this.handlers.toArray(h);
    }

    public int getMessageCount() {
        return this.messageCount.get();
    }

    public void selectLoopHook(boolean before) {
        if (this.batchedMode.get()) {
            this.flushBatch(this.stealBatch());
        }
    }
}

