/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class DeploymentLog {
    private final List<Entry> entries;
    private final boolean active;
    private final OptionalLong last;

    public DeploymentLog(List<Entry> entries, boolean active, OptionalLong last) {
        this.entries = entries.stream().sorted(Comparator.comparing(Entry::at)).collect(Collectors.toUnmodifiableList());
        this.active = active;
        this.last = last;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public boolean isActive() {
        return this.active;
    }

    public OptionalLong last() {
        return this.last;
    }

    public static class Entry {
        private final Instant at;
        private final String level;
        private final String message;

        public Entry(Instant at, String level, String message) {
            this.at = at;
            this.level = level;
            this.message = message;
        }

        public Instant at() {
            return this.at;
        }

        public String level() {
            return this.level;
        }

        public String message() {
            return this.message;
        }
    }
}

