/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.local;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.fieldset.FieldSet;
import com.yahoo.document.fieldset.FieldSetRepo;
import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.ProgressToken;
import com.yahoo.documentapi.VisitorControlHandler;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorDataQueue;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.VisitorResponse;
import com.yahoo.documentapi.VisitorSession;
import com.yahoo.documentapi.local.LocalDocumentAccess;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.messagebus.Trace;
import com.yahoo.yolean.Exceptions;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;

public class LocalVisitorSession
implements VisitorSession {
    private final VisitorDataHandler data;
    private final VisitorControlHandler control;
    private final Map<DocumentId, Document> outstanding;
    private final DocumentSelector selector;
    private final FieldSet fieldSet;
    private final AtomicReference<State> state;
    private final AtomicReference<Phaser> phaser;
    private final ProgressToken token;

    public LocalVisitorSession(LocalDocumentAccess access, VisitorParameters parameters) throws ParseException {
        this.selector = new DocumentSelector(parameters.getDocumentSelection());
        this.fieldSet = new FieldSetRepo().parse(access.getDocumentTypeManager(), parameters.fieldSet());
        this.token = parameters.getResumeToken();
        if (parameters.getRemoteDataHandler() == null) {
            this.data = parameters.getLocalDataHandler() == null ? new VisitorDataQueue() : parameters.getLocalDataHandler();
            this.data.reset();
            this.data.setSession(this);
        } else {
            if (parameters.getLocalDataHandler() != null) {
                throw new IllegalArgumentException("Cannot have both a remote and a local data handler");
            }
            this.data = null;
        }
        this.control = parameters.getControlHandler() == null ? new VisitorControlHandler() : parameters.getControlHandler();
        this.control.reset();
        this.control.setSession(this);
        this.outstanding = new ConcurrentSkipListMap<DocumentId, Document>(Comparator.comparing(DocumentId::toString));
        this.outstanding.putAll(access.documents);
        this.state = new AtomicReference<State>(State.RUNNING);
        this.phaser = access.phaser;
        this.start();
    }

    void start() {
        Phaser synchronizer = this.phaser.get();
        if (synchronizer != null) {
            synchronizer.register();
        }
        new Thread(() -> {
            try {
                this.outstanding.forEach((id, document) -> {
                    if (this.state.get() != State.RUNNING) {
                        return;
                    }
                    try {
                        if (this.selector.accepts((DocumentOperation)new DocumentPut(document)) != Result.TRUE) {
                            return;
                        }
                    }
                    catch (RuntimeException e) {
                        return;
                    }
                    Document copy = new Document(document.getDataType(), document.getId());
                    new FieldSetRepo().copyFields(document, copy, this.fieldSet);
                    if (synchronizer != null) {
                        synchronizer.arriveAndAwaitAdvance();
                    }
                    if (this.data != null) {
                        this.data.onMessage(new PutDocumentMessage(new DocumentPut(copy)), new AckToken(id));
                    } else {
                        this.outstanding.remove(id);
                    }
                    if (synchronizer != null) {
                        synchronizer.arriveAndAwaitAdvance();
                    }
                });
                this.state.updateAndGet(current -> {
                    switch (current) {
                        case RUNNING: {
                            this.control.onDone(VisitorControlHandler.CompletionCode.SUCCESS, "Success");
                            return State.SUCCESS;
                        }
                        case ABORTED: {
                            this.control.onDone(VisitorControlHandler.CompletionCode.ABORTED, "Aborted by user");
                            return State.ABORTED;
                        }
                    }
                    this.control.onDone(VisitorControlHandler.CompletionCode.FAILURE, "Unexpected state '" + current + "'");
                    return State.FAILURE;
                });
            }
            catch (Exception e) {
                this.state.set(State.FAILURE);
                this.outstanding.clear();
                this.control.onDone(VisitorControlHandler.CompletionCode.FAILURE, Exceptions.toMessageString((Throwable)e));
            }
            finally {
                if (synchronizer != null) {
                    synchronizer.arriveAndDeregister();
                }
                if (this.data != null) {
                    this.data.onDone();
                }
            }
        }).start();
    }

    @Override
    public boolean isDone() {
        return this.outstanding.isEmpty() && this.control.isDone();
    }

    @Override
    public ProgressToken getProgress() {
        return this.token;
    }

    @Override
    public Trace getTrace() {
        throw new UnsupportedOperationException("Traces are not supported");
    }

    @Override
    public boolean waitUntilDone(long timeoutMs) throws InterruptedException {
        return this.control.waitUntilDone(timeoutMs);
    }

    @Override
    public void ack(AckToken token) {
        this.outstanding.remove((DocumentId)token.ackObject);
    }

    @Override
    public void abort() {
        this.state.updateAndGet(current -> current == State.RUNNING ? State.ABORTED : current);
        this.outstanding.clear();
    }

    @Override
    public VisitorResponse getNext() {
        return this.data.getNext();
    }

    @Override
    public VisitorResponse getNext(int timeoutMilliseconds) throws InterruptedException {
        return this.data.getNext(timeoutMilliseconds);
    }

    @Override
    public void destroy() {
        this.abort();
        try {
            this.control.waitUntilDone(0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static enum State {
        RUNNING,
        FAILURE,
        ABORTED,
        SUCCESS;

    }
}

