/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.local;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentIdResponse;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.DocumentUpdateResponse;
import com.yahoo.documentapi.RemoveResponse;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.ResponseHandler;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.UpdateResponse;
import com.yahoo.documentapi.local.LocalDocumentAccess;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class LocalAsyncSession
implements AsyncSession {
    private final BlockingQueue<Response> responses = new LinkedBlockingQueue<Response>();
    private final ResponseHandler handler;
    private final SyncSession syncSession;
    private final Executor executor = Executors.newCachedThreadPool();
    private final AtomicReference<Phaser> phaser;
    private AtomicLong requestId = new AtomicLong(0L);
    private AtomicReference<Result.ResultType> result = new AtomicReference<Result.ResultType>(Result.ResultType.SUCCESS);

    public LocalAsyncSession(AsyncParameters params, LocalDocumentAccess access) {
        this.handler = params.getResponseHandler();
        this.syncSession = access.createSyncSession(new SyncParameters.Builder().build());
        this.phaser = access.phaser;
    }

    @Override
    public double getCurrentWindowSize() {
        return 1000.0;
    }

    @Override
    public Result put(Document document) {
        return this.put(new DocumentPut(document), DocumentOperationParameters.parameters());
    }

    @Override
    public Result put(DocumentPut documentPut, DocumentOperationParameters parameters) {
        return this.send(req -> {
            try {
                this.syncSession.put(documentPut, parameters);
                return new DocumentResponse((long)req, documentPut.getDocument());
            }
            catch (Exception e) {
                return new DocumentResponse((long)req, documentPut.getDocument(), e.getMessage(), Response.Outcome.ERROR);
            }
        }, parameters);
    }

    @Override
    public Result get(DocumentId id) {
        return this.get(id, DocumentOperationParameters.parameters());
    }

    @Override
    public Result get(DocumentId id, DocumentOperationParameters parameters) {
        return this.send(req -> {
            try {
                return new DocumentResponse((long)req, this.syncSession.get(id, parameters, null));
            }
            catch (Exception e) {
                return new DocumentResponse((long)req, null, e.getMessage(), Response.Outcome.ERROR);
            }
        }, parameters);
    }

    @Override
    public Result remove(DocumentId id) {
        return this.remove(id, DocumentOperationParameters.parameters());
    }

    @Override
    public Result remove(DocumentRemove remove, DocumentOperationParameters parameters) {
        return this.send(req -> {
            if (this.syncSession.remove(remove, parameters)) {
                return new RemoveResponse((long)req, true);
            }
            return new DocumentIdResponse((long)req, remove.getId(), "Document not found.", Response.Outcome.NOT_FOUND);
        }, parameters);
    }

    @Override
    public Result update(DocumentUpdate update) {
        return this.update(update, DocumentOperationParameters.parameters());
    }

    @Override
    public Result update(DocumentUpdate update, DocumentOperationParameters parameters) {
        return this.send(req -> {
            if (this.syncSession.update(update, parameters)) {
                return new UpdateResponse((long)req, true);
            }
            return new DocumentUpdateResponse((long)req, update, "Document not found.", Response.Outcome.NOT_FOUND);
        }, parameters);
    }

    @Override
    public Response getNext() {
        return (Response)this.responses.poll();
    }

    @Override
    public Response getNext(int timeoutMilliseconds) throws InterruptedException {
        return this.responses.poll(timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
    }

    public void setResultType(Result.ResultType resultType) {
        this.result.set(resultType);
    }

    private void addResponse(Response response) {
        if (this.handler != null) {
            this.handler.handleResponse(response);
        } else {
            this.responses.add(response);
        }
    }

    private Result send(Function<Long, Response> responses, DocumentOperationParameters parameters) {
        Result.ResultType resultType = this.result.get();
        if (resultType != Result.ResultType.SUCCESS) {
            return new Result(resultType, new Error());
        }
        ResponseHandler responseHandler = parameters.responseHandler().orElse(this::addResponse);
        long req = this.requestId.incrementAndGet();
        Phaser synchronizer = this.phaser.get();
        if (synchronizer == null) {
            responseHandler.handleResponse(responses.apply(req));
        } else {
            synchronizer.register();
            this.executor.execute(() -> {
                try {
                    synchronizer.arriveAndAwaitAdvance();
                    responseHandler.handleResponse((Response)responses.apply(req));
                }
                finally {
                    synchronizer.awaitAdvance(synchronizer.arriveAndDeregister());
                }
            });
        }
        return new Result(req);
    }
}

