/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.VerbatimDirective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalServicePolicy
implements DocumentProtocolRoutingPolicy {
    private final String localAddress;
    private Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();

    LocalServicePolicy(String param) {
        this.localAddress = param != null && param.length() > 0 ? param : null;
    }

    public void select(RoutingContext ctx) {
        Route route = new Route(ctx.getRoute());
        route.setHop(0, this.getRecipient(ctx));
        ctx.addChild(route);
    }

    public void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx);
    }

    private synchronized Hop getRecipient(RoutingContext ctx) {
        CacheEntry entry = this.update(ctx);
        if (entry.recipients.isEmpty()) {
            Hop hop = new Hop(ctx.getRoute().getHop(0));
            hop.setDirective(ctx.getDirectiveIndex(), (HopDirective)new VerbatimDirective("*"));
            return hop;
        }
        if (++entry.offset >= entry.recipients.size()) {
            entry.offset = 0;
        }
        return new Hop(entry.recipients.get(entry.offset));
    }

    private CacheEntry update(RoutingContext ctx) {
        int upd;
        String key = this.getCacheKey(ctx);
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            entry = new CacheEntry();
            this.cache.put(key, entry);
        }
        if (entry.generation != (upd = ctx.getMirror().updates())) {
            entry.generation = upd;
            entry.recipients.clear();
            List arr = ctx.getMirror().lookup(ctx.getHopPrefix() + "*" + ctx.getHopSuffix());
            String self = this.localAddress != null ? this.localAddress : LocalServicePolicy.toAddress(ctx.getMessageBus().getConnectionSpec());
            for (Mirror.Entry item : arr) {
                if (!self.equals(LocalServicePolicy.toAddress(item.getSpec()))) continue;
                entry.recipients.add(Hop.parse((String)item.getName()));
            }
        }
        return entry;
    }

    private String getCacheKey(RoutingContext ctx) {
        return ctx.getRoute().getHop(0).toString();
    }

    private static String toAddress(String connection) {
        int pos;
        if (connection.startsWith("tcp/") && (pos = connection.indexOf(58)) > 4) {
            return connection.substring(4, pos);
        }
        return null;
    }

    public void destroy() {
    }

    private class CacheEntry {
        private final List<Hop> recipients = new ArrayList<Hop>();
        private int generation = 0;
        private int offset = 0;

        private CacheEntry() {
        }
    }
}

