/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.jrt.slobrok.api.Mirror;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancer {
    private final List<NodeMetrics> nodeWeights = new ArrayList<NodeMetrics>();
    private final Map<String, Integer> cachedIndex = new HashMap<String, Integer>();
    private final String cluster;
    private double position = 0.0;

    public LoadBalancer(String cluster) {
        this.cluster = cluster;
    }

    public List<NodeMetrics> getNodeWeights() {
        return this.nodeWeights;
    }

    int getIndex(String nodeName) {
        try {
            String s = nodeName.substring(this.cluster.length() + 1);
            s = s.substring(0, s.indexOf("/"));
            s = s.substring(s.lastIndexOf(".") + 1);
            return Integer.parseInt(s);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            String err = "Expected recipient on the form '" + this.cluster + "/x/[y.]number/z', got '" + nodeName + "'.";
            throw new IllegalArgumentException(err, e);
        }
    }

    private int getCachedIndex(String nodeName) {
        return this.cachedIndex.computeIfAbsent(nodeName, key -> this.getIndex((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getRecipient(List<Mirror.Entry> choices) {
        if (choices.isEmpty()) {
            return null;
        }
        double weightSum = 0.0;
        Node selectedNode = null;
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            for (Mirror.Entry entry : choices) {
                NodeMetrics nodeMetrics = this.getNodeMetrics(entry);
                if (!((weightSum += nodeMetrics.weight) > this.position)) continue;
                selectedNode = new Node(entry, nodeMetrics);
                break;
            }
            if (selectedNode == null) {
                this.position -= weightSum;
                selectedNode = new Node(choices.get(0), this.getNodeMetrics(choices.get(0)));
            }
            this.position += 1.0;
            ++selectedNode.metrics.sent;
        }
        return selectedNode;
    }

    private NodeMetrics getNodeMetrics(Mirror.Entry entry) {
        int index = this.getCachedIndex(entry.getName());
        while (this.nodeWeights.size() < index + 1) {
            this.nodeWeights.add(null);
        }
        NodeMetrics nodeMetrics = this.nodeWeights.get(index);
        if (nodeMetrics == null) {
            nodeMetrics = new NodeMetrics();
            this.nodeWeights.set(index, nodeMetrics);
        }
        return nodeMetrics;
    }

    private void increaseWeights() {
        for (NodeMetrics n : this.nodeWeights) {
            if (n == null) continue;
            double want = n.weight * 1.0101010101010102;
            if (want >= 1.0) {
                n.weight = want;
                continue;
            }
            n.weight = 1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(Node node, boolean busy) {
        if (busy) {
            LoadBalancer loadBalancer = this;
            synchronized (loadBalancer) {
                double wantWeight = node.metrics.weight - 0.01;
                if (wantWeight < 1.0) {
                    this.increaseWeights();
                    node.metrics.weight = 1.0;
                } else {
                    node.metrics.weight = wantWeight;
                }
                ++node.metrics.busy;
            }
        }
    }

    static class Node {
        Mirror.Entry entry;
        NodeMetrics metrics;

        Node(Mirror.Entry e, NodeMetrics m) {
            this.entry = e;
            this.metrics = m;
        }
    }

    static class NodeMetrics {
        long sent = 0L;
        long busy = 0L;
        double weight = 1.0;

        NodeMetrics() {
        }
    }
}

