/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ThroughputLimitQueue<M>
extends LinkedBlockingQueue<M> {
    private static Logger log = Logger.getLogger(ThroughputLimitQueue.class.getName());
    double averageWaitTime = 0.0;
    long maxWaitTime = 0L;
    long startTime;
    int capacity = 2;
    Timer timer;

    public ThroughputLimitQueue(long queueSizeInMs) {
        this((Timer)SystemTimer.INSTANCE, queueSizeInMs);
    }

    public ThroughputLimitQueue(Timer t, long queueSizeInMs) {
        this.maxWaitTime = queueSizeInMs;
        this.timer = t;
    }

    @Override
    public boolean add(M m) {
        if (!this.offer(m)) {
            throw new IllegalStateException("Queue full");
        }
        return true;
    }

    @Override
    public boolean offer(M m) {
        return this.remainingCapacity() > 0 && super.offer(m);
    }

    private M calculateAverage(M m) {
        if (m == null) {
            this.startTime = 0L;
            return null;
        }
        if (this.startTime != 0L) {
            long waitTime = this.timer.milliTime() - this.startTime;
            this.averageWaitTime = this.averageWaitTime == 0.0 ? (double)waitTime : 0.99 * this.averageWaitTime + 0.01 * (double)waitTime;
            int newCapacity = Math.max(2, (int)Math.round((double)this.maxWaitTime / this.averageWaitTime));
            if (newCapacity != this.capacity) {
                log.fine("Capacity of throughput queue changed from " + this.capacity + " to " + newCapacity);
                this.capacity = newCapacity;
            }
        }
        this.startTime = !this.isEmpty() ? this.timer.milliTime() : 0L;
        return m;
    }

    @Override
    public M poll() {
        return (M)this.calculateAverage(super.poll());
    }

    @Override
    public void put(M m) throws InterruptedException {
        this.offer(m, Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public boolean offer(M m, long l, TimeUnit timeUnit) throws InterruptedException {
        for (long timeWaited = 0L; timeWaited < timeUnit.toMillis(l); timeWaited += 10L) {
            if (this.offer(m)) {
                return true;
            }
            Thread.sleep(10L);
        }
        return false;
    }

    @Override
    public M take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public M poll(long l, TimeUnit timeUnit) throws InterruptedException {
        for (long timeWaited = 0L; timeWaited < timeUnit.toMillis(l); timeWaited += 10L) {
            M elem = this.poll();
            if (elem != null) {
                return elem;
            }
            Thread.sleep(10L);
        }
        return null;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        int sz = this.capacity - this.size();
        return sz > 0 ? sz : 0;
    }

    @Override
    public boolean addAll(Collection<? extends M> ms) {
        for (M m : ms) {
            if (this.offer(m)) continue;
            return false;
        }
        return true;
    }
}

