/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.systemstate.rule;

import com.yahoo.documentapi.messagebus.systemstate.rule.Argument;
import com.yahoo.log.LogLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeState {
    public static final String NODE_PARENT = "..";
    public static final String NODE_CURRENT = ".";
    private static Logger log = Logger.getLogger(NodeState.class.getName());
    private final Map<String, NodeState> children = new LinkedHashMap<String, NodeState>();
    private final Map<String, String> state = new LinkedHashMap<String, String>();
    private NodeState parent = null;
    private String id = null;

    public NodeState() {
    }

    public NodeState(List<Argument> args) {
        for (Argument arg : args) {
            this.setState(arg.getName(), arg.getValue());
        }
    }

    public NodeState addChild(String key, NodeState child) {
        this.getChild(key, true).copy(child);
        return this;
    }

    public NodeState getChild(String key) {
        return this.getChild(key, false);
    }

    public NodeState getChild(String key, boolean force) {
        if (key == null || key.length() == 0) {
            return this;
        }
        String[] arr = key.split("/", 2);
        while (arr.length == 2 && arr[0].equals(NODE_CURRENT)) {
            arr = arr[1].split("/", 2);
        }
        if (arr[0].equals(NODE_CURRENT)) {
            return this;
        }
        if (arr[0].equals(NODE_PARENT)) {
            if (this.parent == null) {
                log.log((Level)LogLevel.ERROR, "Location string '" + key + "' requests a parent above the top-most node, returning self to avoid crash.");
            }
            return this.parent.getChild(arr[1], force);
        }
        if (!this.children.containsKey(arr[0])) {
            if (!force) {
                return null;
            }
            this.children.put(arr[0], new NodeState());
            this.children.get(arr[0]).setParent(this, arr[0]);
        }
        if (arr.length == 2) {
            return this.children.get(arr[0]).getChild(arr[1], force);
        }
        return this.children.get(arr[0]);
    }

    public Map<String, NodeState> getChildren() {
        return this.children;
    }

    public NodeState removeChild(String key) {
        if (key == null || key.length() == 0) {
            return this;
        }
        int pos = key.lastIndexOf("/");
        if (pos > -1) {
            NodeState parent = this.getChild(key.substring(0, pos), false);
            if (parent != null) {
                return parent.removeChild(key.substring(pos + 1));
            }
        } else {
            this.children.remove(key);
        }
        return this.compact();
    }

    public String getState(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        int pos = key.lastIndexOf("/");
        if (pos > -1) {
            NodeState parent = this.getChild(key.substring(0, pos), false);
            return parent != null ? parent.getState(key.substring(pos + 1)) : null;
        }
        return this.state.get(key);
    }

    public NodeState setState(String key, String value) {
        if (key == null || key.length() == 0) {
            return this;
        }
        int pos = key.lastIndexOf("/");
        if (pos > -1) {
            this.getChild(key.substring(0, pos), true).setState(key.substring(pos + 1), value);
        } else {
            if (value == null || value.length() == 0) {
                return this.removeState(key);
            }
            this.state.put(key, value);
        }
        return this;
    }

    public NodeState removeState(String key) {
        if (key == null || key.length() == 0) {
            return this;
        }
        int pos = key.lastIndexOf("/");
        if (pos > -1) {
            NodeState parent = this.getChild(key.substring(0, pos), false);
            if (parent != null) {
                return parent.removeState(key.substring(pos + 1));
            }
        } else {
            this.state.remove(key);
        }
        return this.compact();
    }

    private NodeState compact() {
        if (this.state.isEmpty() && this.children.isEmpty() && this.parent != null) {
            return this.parent.removeChild(this.id);
        }
        return this;
    }

    public NodeState copy(NodeState node) {
        for (String key : node.state.keySet()) {
            this.state.put(key, node.state.get(key));
        }
        for (String key : node.children.keySet()) {
            this.getChild(key, true).copy(node.children.get(key));
        }
        return this;
    }

    public NodeState clear() {
        this.state.clear();
        this.children.clear();
        return this.compact();
    }

    public NodeState setParent(NodeState parent, String id) {
        this.parent = parent;
        this.id = id;
        return this;
    }

    private String toString(String prefix) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        if (!this.state.isEmpty()) {
            buf.append(prefix.length() == 0 ? NODE_CURRENT : prefix).append("?");
            String[] arr = this.state.keySet().toArray(new String[this.state.keySet().size()]);
            for (int i = 0; i < arr.length; ++i) {
                buf.append(arr[i]).append("=").append(URLEncoder.encode(this.state.get(arr[i]), "UTF-8"));
                if (i >= arr.length - 1) continue;
                buf.append("&");
            }
            buf.append(" ");
        }
        if (prefix.length() > 0) {
            prefix = prefix + "/";
        }
        Object[] keys = this.children.keySet().toArray(new String[this.children.keySet().size()]);
        Arrays.sort(keys);
        for (Object loc : keys) {
            buf.append(this.children.get(loc).toString(prefix + URLEncoder.encode((String)loc, "UTF-8")));
        }
        return buf.toString();
    }

    public String toString() {
        try {
            return this.toString("").trim();
        }
        catch (UnsupportedEncodingException e) {
            return e.toString();
        }
    }
}

