/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class TokenBuffer {
    private final Deque<Token> buffer;
    private int nesting = 0;

    public TokenBuffer() {
        this(new ArrayDeque<Token>());
    }

    private TokenBuffer(Deque<Token> buffer) {
        this.buffer = buffer;
        if (buffer.size() > 0) {
            this.updateNesting(buffer.peekFirst().token);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public JsonToken next() {
        this.buffer.removeFirst();
        Token t = this.buffer.peekFirst();
        if (t == null) {
            return null;
        }
        this.updateNesting(t.token);
        return t.token;
    }

    public JsonToken currentToken() {
        Token token = this.buffer.peekFirst();
        if (token == null) {
            return null;
        }
        return token.token;
    }

    public String currentName() {
        Token token = this.buffer.peekFirst();
        if (token == null) {
            return null;
        }
        return token.name;
    }

    public String currentText() {
        Token token = this.buffer.peekFirst();
        if (token == null) {
            return null;
        }
        return token.text;
    }

    public int size() {
        return this.buffer.size();
    }

    private void add(JsonToken token, String name, String text) {
        this.buffer.addLast(new Token(token, name, text));
    }

    public void bufferObject(JsonToken first, JsonParser tokens) {
        this.bufferJsonStruct(first, tokens, JsonToken.START_OBJECT);
    }

    public void bufferArray(JsonToken first, JsonParser tokens) {
        this.bufferJsonStruct(first, tokens, JsonToken.START_ARRAY);
    }

    private void bufferJsonStruct(JsonToken first, JsonParser tokens, JsonToken firstToken) {
        int localNesting = 0;
        JsonToken t = first;
        Preconditions.checkArgument((first == firstToken ? 1 : 0) != 0, (String)"Expected %s, got %s.", (Object)firstToken.name(), (Object)t);
        if (this.size() == 0) {
            this.updateNesting(t);
        }
        localNesting = this.storeAndPeekNesting(t, localNesting, tokens);
        while (localNesting > 0) {
            t = this.nextValue(tokens);
            localNesting = this.storeAndPeekNesting(t, localNesting, tokens);
        }
    }

    private int storeAndPeekNesting(JsonToken t, int nesting, JsonParser tokens) {
        this.addFromParser(t, tokens);
        return nesting + this.nestingOffset(t);
    }

    private int nestingOffset(JsonToken t) {
        if (t.isStructStart()) {
            return 1;
        }
        if (t.isStructEnd()) {
            return -1;
        }
        return 0;
    }

    private void addFromParser(JsonToken t, JsonParser tokens) {
        try {
            this.add(t, tokens.getCurrentName(), tokens.getText());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private JsonToken nextValue(JsonParser tokens) {
        try {
            return tokens.nextValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void updateNesting(JsonToken t) {
        this.nesting += this.nestingOffset(t);
    }

    public int nesting() {
        return this.nesting;
    }

    public String dumpContents() {
        StringBuilder b = new StringBuilder();
        b.append("[nesting: ").append(this.nesting()).append("\n");
        for (Token t : this.buffer) {
            b.append("(").append(t.token).append(", \"").append(t.name).append("\", \"").append(t.text).append("\")\n");
        }
        b.append("]\n");
        return b.toString();
    }

    public void fastForwardToEndObject() {
        JsonToken t = this.currentToken();
        while (t != JsonToken.END_OBJECT) {
            t = this.next();
        }
    }

    public TokenBuffer prefetchCurrentElement() {
        ArrayDeque<Token> copy = new ArrayDeque<Token>();
        if (this.currentToken().isScalarValue()) {
            copy.add(this.buffer.peekFirst());
        } else {
            int localNesting;
            int nestingBarrier = localNesting = this.nesting();
            for (Token t : this.buffer) {
                copy.add(t);
                if ((localNesting += this.nestingOffset(t.token)) >= nestingBarrier) continue;
                break;
            }
        }
        return new TokenBuffer(copy);
    }

    public Token prefetchScalar(String name) {
        int localNesting;
        int nestingBarrier = localNesting = this.nesting();
        Token toReturn = null;
        if (name.equals(this.currentName()) && this.currentToken().isScalarValue()) {
            toReturn = this.buffer.peekFirst();
        } else {
            Iterator<Token> i = this.buffer.iterator();
            i.next();
            while (i.hasNext()) {
                Token t = i.next();
                if (localNesting == nestingBarrier && name.equals(t.name) && t.token.isScalarValue()) {
                    toReturn = t;
                    break;
                }
                if ((localNesting += this.nestingOffset(t.token)) >= nestingBarrier) continue;
                break;
            }
        }
        return toReturn;
    }

    public void skipToRelativeNesting(int relativeNesting) {
        int initialNesting = this.nesting();
        do {
            this.next();
        } while (this.nesting() > initialNesting + relativeNesting);
    }

    public static final class Token {
        public final JsonToken token;
        public final String name;
        public final String text;

        Token(JsonToken token, String name, String text) {
            this.token = token;
            this.name = name;
            this.text = text;
        }
    }
}

