/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;

public class AddValueUpdate
extends ValueUpdate {
    protected FieldValue value;
    protected Integer weight;

    AddValueUpdate(FieldValue value) {
        super(ValueUpdate.ValueUpdateClassID.ADD);
        this.setValue(value, 1);
    }

    public AddValueUpdate(FieldValue key, int weight) {
        super(ValueUpdate.ValueUpdateClassID.ADD);
        this.setValue(key, weight);
    }

    private void setValue(FieldValue key, int weight) {
        this.value = key;
        this.weight = weight;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public void setValue(FieldValue value) {
        this.value = value;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public FieldValue applyTo(FieldValue val) {
        if (val instanceof WeightedSet) {
            WeightedSet wset = (WeightedSet)val;
            wset.put(this.value, this.weight);
        } else if (val instanceof CollectionFieldValue) {
            CollectionFieldValue fval = (CollectionFieldValue)val;
            fval.add(this.value);
        } else {
            throw new IllegalStateException("Cannot add " + this.value + " to field of type " + val.getClass().getName());
        }
        return val;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof CollectionDataType)) {
            throw new UnsupportedOperationException("Expected collection, got " + fieldType.getName() + ".");
        }
        fieldType = ((CollectionDataType)fieldType).getNestedType();
        if (this.value != null && !this.value.getDataType().equals(fieldType)) {
            throw new IllegalArgumentException("Expected " + fieldType.getName() + ", got " + this.value.getDataType().getName());
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this, superType);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AddValueUpdate && super.equals(o) && this.value.equals(((AddValueUpdate)o).value) && this.weight.equals(((AddValueUpdate)o).weight);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.value.hashCode() + this.weight;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.value + " " + this.weight;
    }
}

