/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;

public class JsonParserHelpers {
    public static void expectArrayStart(JsonToken token) {
        try {
            Preconditions.checkState((token == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"Expected start of array, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void expectArrayEnd(JsonToken token) {
        try {
            Preconditions.checkState((token == JsonToken.END_ARRAY ? 1 : 0) != 0, (String)"Expected start of array, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void expectObjectStart(JsonToken token) {
        try {
            Preconditions.checkState((token == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)"Expected start of JSON object, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void expectObjectEnd(JsonToken token) {
        try {
            Preconditions.checkState((token == JsonToken.END_OBJECT ? 1 : 0) != 0, (String)"Expected end of JSON object, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void expectCompositeEnd(JsonToken token) {
        try {
            Preconditions.checkState((boolean)token.isStructEnd(), (String)"Expected end of composite, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void expectScalarValue(JsonToken token) {
        try {
            Preconditions.checkState((boolean)token.isScalarValue(), (String)"Expected to be scalar value, got %s", (Object)token);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

