/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.tensor.Tensor;
import java.util.Objects;

public class TensorAddUpdate
extends ValueUpdate<TensorFieldValue> {
    private TensorFieldValue tensor;

    public TensorAddUpdate(TensorFieldValue tensor) {
        super(ValueUpdate.ValueUpdateClassID.TENSORADD);
        this.tensor = tensor;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            throw new UnsupportedOperationException("Expected tensor type, got " + fieldType.getName() + ".");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (!(oldValue instanceof TensorFieldValue)) {
            throw new IllegalStateException("Cannot use tensor add update on non-tensor datatype " + oldValue.getClass().getName());
        }
        if (!((TensorFieldValue)oldValue).getTensor().isPresent()) {
            throw new IllegalArgumentException("No existing tensor to apply update to");
        }
        if (!this.tensor.getTensor().isPresent()) {
            return oldValue;
        }
        Tensor old = ((TensorFieldValue)oldValue).getTensor().get();
        Tensor update = this.tensor.getTensor().get();
        Tensor result = old.merge(update, (left, right) -> right);
        return new TensorFieldValue(result);
    }

    @Override
    public TensorFieldValue getValue() {
        return this.tensor;
    }

    @Override
    public void setValue(TensorFieldValue value) {
        this.tensor = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TensorAddUpdate that = (TensorAddUpdate)o;
        return this.tensor.equals(that.tensor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tensor);
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.tensor);
    }
}

