/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.config.InnerNode;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.internal.GeoPosType;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DocumentTypeManagerConfigurer
implements ConfigSubscriber.SingleSubscriber<DocumentmanagerConfig> {
    private static final Logger log = Logger.getLogger(DocumentTypeManagerConfigurer.class.getName());
    private final DocumentTypeManager managerToConfigure;

    public DocumentTypeManagerConfigurer(DocumentTypeManager manager) {
        this.managerToConfigure = manager;
    }

    public static ConfigSubscriber configure(DocumentTypeManager manager, String configId) {
        return new DocumentTypeManagerConfigurer(manager).configure(configId);
    }

    public ConfigSubscriber configure(String configId) {
        ConfigSubscriber subscriber = new ConfigSubscriber();
        try {
            subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, DocumentmanagerConfig.class, configId);
            return subscriber;
        }
        catch (RuntimeException e) {
            subscriber.close();
            throw e;
        }
    }

    static void configureNewManager(DocumentmanagerConfig config, DocumentTypeManager manager) {
        if (config == null) {
            return;
        }
        manager.setIgnoreUndefinedFields(config.ignoreundefinedfields());
        new Apply(config, manager);
        if (config.datatype().size() == 0 && config.annotationtype().size() == 0) {
            new ApplyNewDoctypeConfig(config, manager);
        }
    }

    public static DocumentTypeManager configureNewManager(DocumentmanagerConfig config) {
        DocumentTypeManager manager = new DocumentTypeManager();
        DocumentTypeManagerConfigurer.configureNewManager(config, manager);
        return manager;
    }

    public void configure(DocumentmanagerConfig config) {
        DocumentTypeManager manager = DocumentTypeManagerConfigurer.configureNewManager(config);
        int defaultTypeCount = new DocumentTypeManager().getDataTypes().size();
        if (this.managerToConfigure.getDataTypes().size() != defaultTypeCount) {
            log.log(Level.FINE, "Live document config overwritten with new config.");
        }
        this.managerToConfigure.internalAssign(manager);
    }

    private static class Apply {
        private final Map<Integer, DataType> typesById = new HashMap<Integer, DataType>();
        private final Map<String, DataType> typesByName = new HashMap<String, DataType>();
        private final Map<Integer, DocumentmanagerConfig.Datatype> configMap = new HashMap<Integer, DocumentmanagerConfig.Datatype>();
        private final boolean usev8geopositions;
        private final DocumentTypeManager manager;

        public Apply(DocumentmanagerConfig config, DocumentTypeManager manager) {
            this.manager = manager;
            this.usev8geopositions = config.usev8geopositions();
            this.apply(config);
        }

        private void inProgress(DataType type) {
            DataType old = this.typesById.put(type.getId(), type);
            if (old != null) {
                throw new IllegalArgumentException("Multiple types with same id: " + String.valueOf(old) + " -> " + String.valueOf(type));
            }
            old = this.typesByName.put(type.getName(), type);
            if (old != null) {
                log.warning("Multiple types with same name: " + String.valueOf(old) + " -> " + String.valueOf(type));
            }
        }

        boolean looksLikePosition(StructDataType type) {
            StructDataType pos = PositionDataType.INSTANCE;
            return type.getName().equals(pos.getName()) && type.getId() == pos.getId();
        }

        private void startStructsAndDocs(DocumentmanagerConfig config) {
            int id;
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Structtype o : thisDataType.structtype()) {
                    id = thisDataType.id();
                    StructDataType type = new StructDataType(id, o.name());
                    if (this.usev8geopositions && this.looksLikePosition(type)) {
                        type = new GeoPosType(8);
                    }
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Documenttype doc : thisDataType.documenttype()) {
                    id = thisDataType.id();
                    StructDataType header = (StructDataType)this.typesById.get(doc.headerstruct());
                    Set<String> importedFields = doc.importedfield().stream().map(f -> f.name()).collect(Collectors.toUnmodifiableSet());
                    DocumentType type = new DocumentType(doc.name(), header, importedFields);
                    if (id != type.getId()) {
                        this.typesById.put(id, type);
                        int alt = (doc.name() + "." + doc.version()).hashCode();
                        log.warning("Document type " + doc.name() + " wanted id " + id + " but got " + type.getId() + ", alternative id was: " + alt);
                    }
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
        }

        private DataType createArrayType(int id, DocumentmanagerConfig.Datatype.Arraytype array) {
            DataType nestedType = this.getOrCreateType(array.datatype());
            ArrayDataType type = new ArrayDataType(nestedType, id);
            this.inProgress(type);
            return type;
        }

        private DataType createMapType(int id, DocumentmanagerConfig.Datatype.Maptype map) {
            DataType keyType = this.getOrCreateType(map.keytype());
            DataType valType = this.getOrCreateType(map.valtype());
            MapDataType type = new MapDataType(keyType, valType, id);
            this.inProgress(type);
            return type;
        }

        private DataType createWeightedSetType(int id, DocumentmanagerConfig.Datatype.Weightedsettype wset) {
            DataType nestedType = this.getOrCreateType(wset.datatype());
            WeightedSetDataType type = new WeightedSetDataType(nestedType, wset.createifnonexistant(), wset.removeifzero(), id);
            this.inProgress(type);
            return type;
        }

        private DataType createReferenceType(int id, DocumentmanagerConfig.Datatype.Referencetype refType) {
            int targetId = refType.target_type_id();
            DocumentType targetDocType = (DocumentType)this.typesById.get(targetId);
            ReferenceDataType type = new ReferenceDataType(targetDocType, id);
            this.inProgress(type);
            return type;
        }

        private DataType getOrCreateType(int id) {
            if (this.typesById.containsKey(id)) {
                return this.typesById.get(id);
            }
            DocumentmanagerConfig.Datatype config = this.configMap.remove(id);
            if (config == null) {
                return this.manager.getDataTypeByCode(id);
            }
            assert (id == config.id());
            Iterator<InnerNode> iterator = config.arraytype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Arraytype o = iterator.next();
                return this.createArrayType(id, o);
            }
            iterator = config.maptype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Maptype o = (DocumentmanagerConfig.Datatype.Maptype)iterator.next();
                return this.createMapType(id, o);
            }
            iterator = config.weightedsettype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Weightedsettype o = (DocumentmanagerConfig.Datatype.Weightedsettype)iterator.next();
                return this.createWeightedSetType(id, o);
            }
            iterator = config.referencetype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Referencetype o = (DocumentmanagerConfig.Datatype.Referencetype)iterator.next();
                return this.createReferenceType(id, o);
            }
            throw new IllegalArgumentException("Could not create type from config: " + String.valueOf((Object)config));
        }

        private void createRemainingTypes(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                int id = thisDataType.id();
                DataType type = this.getOrCreateType(id);
                assert (type != null);
            }
        }

        private void fillStructs(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Structtype struct : thisDataType.structtype()) {
                    int id = thisDataType.id();
                    StructDataType type = (StructDataType)this.typesById.get(id);
                    if (type instanceof GeoPosType) continue;
                    for (DocumentmanagerConfig.Datatype.Structtype.Inherits parent : struct.inherits()) {
                        StructDataType parentStruct = (StructDataType)this.typesByName.get(parent.name());
                        type.inherit(parentStruct);
                    }
                    for (DocumentmanagerConfig.Datatype.Structtype.Field field : struct.field()) {
                        DataType fieldType;
                        if (field.datatype() == id) {
                            log.fine("Self-referencing struct " + struct.name() + " field: " + String.valueOf((Object)field));
                        }
                        if ((fieldType = this.typesById.get(field.datatype())) == null) {
                            fieldType = this.manager.getDataTypeByCode(field.datatype(), field.detailedtype());
                        }
                        if (field.id().size() == 1) {
                            type.addField(new Field(field.name(), field.id().get(0).id(), fieldType));
                            continue;
                        }
                        type.addField(new Field(field.name(), fieldType));
                    }
                }
            }
        }

        private void fillDocuments(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Documenttype doc : thisDataType.documenttype()) {
                    int id = thisDataType.id();
                    DocumentType type = (DocumentType)this.typesById.get(id);
                    for (DocumentmanagerConfig.Datatype.Documenttype.Inherits parent : doc.inherits()) {
                        DocumentType parentType = (DocumentType)this.typesByName.get(parent.name());
                        if (parentType == null) {
                            DataTypeName name = new DataTypeName(parent.name());
                            parentType = this.manager.getDocumentType(name);
                        }
                        if (parentType == null) {
                            throw new IllegalArgumentException("Could not find parent document type '" + parent.name() + "'.");
                        }
                        type.inherit(parentType);
                    }
                    HashMap<String, Collection<String>> fieldSets = new HashMap<String, Collection<String>>(doc.fieldsets().size());
                    for (Map.Entry<String, DocumentmanagerConfig.Datatype.Documenttype.Fieldsets> entry : doc.fieldsets().entrySet()) {
                        fieldSets.put(entry.getKey(), entry.getValue().fields());
                    }
                    type.addFieldSets(fieldSets);
                }
            }
        }

        private void splitConfig(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype dataTypeConfig : config.datatype()) {
                int id = dataTypeConfig.id();
                DocumentmanagerConfig.Datatype old = this.configMap.put(id, dataTypeConfig);
                if (old == null) continue;
                throw new IllegalArgumentException("Multiple configs for id " + id + " first:\n" + String.valueOf((Object)old) + "\nsecond:\n" + String.valueOf((Object)dataTypeConfig));
            }
        }

        private void apply(DocumentmanagerConfig config) {
            this.splitConfig(config);
            this.setupAnnotationTypesWithoutPayloads(config);
            this.setupAnnotationRefTypes(config);
            this.startStructsAndDocs(config);
            this.createRemainingTypes(config);
            this.fillStructs(config);
            this.fillDocuments(config);
            for (DataType type : this.typesById.values()) {
                this.manager.register(type);
            }
            this.addAnnotationTypePayloads(config);
            this.addAnnotationTypeInheritance(config);
        }

        private void setupAnnotationRefTypes(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                int id = thisDataType.id();
                for (DocumentmanagerConfig.Datatype.Annotationreftype annRefType : thisDataType.annotationreftype()) {
                    AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annRefType.annotation());
                    if (annotationType == null) {
                        throw new IllegalArgumentException("Found reference to " + annRefType.annotation() + ", which does not exist!");
                    }
                    AnnotationReferenceDataType type = new AnnotationReferenceDataType(annotationType, id);
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
        }

        private void setupAnnotationTypesWithoutPayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = new AnnotationType(annType.name(), annType.id());
                this.manager.getAnnotationTypeRegistry().register(annotationType);
            }
        }

        private void addAnnotationTypePayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                DataType payload = this.manager.getDataTypeByCode(annType.datatype(), "");
                if (payload.equals(DataType.NONE)) continue;
                annotationType.setDataType(payload);
            }
        }

        private void addAnnotationTypeInheritance(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                if (annType.inherits().size() <= 0) continue;
                AnnotationType inheritedType = this.manager.getAnnotationTypeRegistry().getType(annType.inherits(0).id());
                AnnotationType type = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                type.inherit(inheritedType);
            }
        }
    }

    private static class ApplyNewDoctypeConfig {
        Map<Integer, DataType> typesByIdx = new HashMap<Integer, DataType>();
        Map<Integer, Supplier<DataType>> factoryByIdx = new HashMap<Integer, Supplier<DataType>>();
        ArrayList<Integer> proxyRefs = new ArrayList();
        private final Map<String, PerDocTypeData> inProgressByName = new HashMap<String, PerDocTypeData>();
        private final Map<Integer, PerDocTypeData> inProgressById = new HashMap<Integer, PerDocTypeData>();
        private final boolean usev8geopositions;
        private final DocumentTypeManager manager;

        public ApplyNewDoctypeConfig(DocumentmanagerConfig config, DocumentTypeManager manager) {
            this.manager = manager;
            this.usev8geopositions = config.usev8geopositions();
            this.apply(config);
        }

        DataType addNewType(int id, DataType type) {
            if (type == null) {
                throw new IllegalArgumentException("Type to add for idx " + id + " cannot be null");
            }
            DataType old = this.typesByIdx.put(id, type);
            if (old != null) {
                throw new IllegalArgumentException("Type " + String.valueOf(type) + " for idx " + id + " conflict: " + String.valueOf(old) + " present");
            }
            return type;
        }

        private DataType getOrCreateType(int id) {
            if (this.typesByIdx.containsKey(id)) {
                return this.typesByIdx.get(id);
            }
            Supplier<DataType> factory = this.factoryByIdx.remove(id);
            if (factory != null) {
                DataType type = factory.get();
                return this.addNewType(id, type);
            }
            throw new IllegalArgumentException("No type or factory found for idx: " + id);
        }

        void createComplexTypes() {
            ArrayList<Integer> toCreate = new ArrayList<Integer>(this.factoryByIdx.keySet());
            for (Integer dataTypeId : toCreate) {
                DataType type = this.getOrCreateType(dataTypeId);
                assert (type != null);
            }
        }

        private void apply(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Doctype docType : config.doctype()) {
                int idx = docType.idx();
                String name = docType.name();
                PerDocTypeData data = new PerDocTypeData(docType);
                PerDocTypeData old = this.inProgressById.put(idx, data);
                if (old != null) {
                    throw new IllegalArgumentException("Multiple document types with id: " + idx);
                }
                old = this.inProgressByName.put(name, data);
                if (old == null) continue;
                throw new IllegalArgumentException("Multiple document types with name: " + name);
            }
            for (DocumentmanagerConfig.Doctype docType : config.doctype()) {
                PerDocTypeData docTypeData = this.inProgressById.get(docType.idx());
                docTypeData.createSimpleTypes();
                docTypeData.createEmptyStructs();
                docTypeData.initializeDocType();
                docTypeData.createEmptyAnnotationTypes();
                docTypeData.createFactories();
            }
            this.createComplexTypes();
            for (DocumentmanagerConfig.Doctype docType : config.doctype()) {
                PerDocTypeData docTypeData = this.inProgressById.get(docType.idx());
                docTypeData.fillStructs();
                docTypeData.fillDocument();
                docTypeData.fillAnnotationTypes();
            }
            Iterator<Object> iterator = this.proxyRefs.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                this.typesByIdx.remove(idx);
            }
            for (PerDocTypeData docTypeData : this.inProgressByName.values()) {
                this.manager.registerSingleType(docTypeData.docType);
            }
        }

        class PerDocTypeData {
            DocumentmanagerConfig.Doctype docTypeConfig;
            DocumentType docType = null;
            private final Field POS_X = PositionDataType.INSTANCE.getField("x");
            private final Field POS_Y = PositionDataType.INSTANCE.getField("y");

            PerDocTypeData(DocumentmanagerConfig.Doctype config) {
                this.docTypeConfig = config;
            }

            void createSimpleTypes() {
                DataType type;
                for (DocumentmanagerConfig.Doctype.Primitivetype primitivetype : this.docTypeConfig.primitivetype()) {
                    type = ApplyNewDoctypeConfig.this.manager.getDataTypeInternal(primitivetype.name());
                    if (!(type instanceof PrimitiveDataType)) {
                        throw new IllegalArgumentException("Needed primitive type for '" + primitivetype.name() + "' [idx " + primitivetype.idx() + "] but got: " + String.valueOf(type));
                    }
                    ApplyNewDoctypeConfig.this.addNewType(primitivetype.idx(), type);
                }
                for (DocumentmanagerConfig.Doctype.Tensortype tensortype : this.docTypeConfig.tensortype()) {
                    type = new TensorDataType(TensorType.fromSpec((String)tensortype.detailedtype()));
                    ApplyNewDoctypeConfig.this.addNewType(tensortype.idx(), type);
                }
            }

            void createFactories() {
                for (DocumentmanagerConfig.Doctype.Arraytype arraytype : this.docTypeConfig.arraytype()) {
                    ApplyNewDoctypeConfig.this.factoryByIdx.put(arraytype.idx(), () -> new ArrayDataType(ApplyNewDoctypeConfig.this.getOrCreateType(arraytype.elementtype())));
                }
                for (DocumentmanagerConfig.Doctype.Maptype maptype : this.docTypeConfig.maptype()) {
                    ApplyNewDoctypeConfig.this.factoryByIdx.put(maptype.idx(), () -> new MapDataType(ApplyNewDoctypeConfig.this.getOrCreateType(maptype.keytype()), ApplyNewDoctypeConfig.this.getOrCreateType(maptype.valuetype())));
                }
                for (DocumentmanagerConfig.Doctype.Wsettype wsettype : this.docTypeConfig.wsettype()) {
                    ApplyNewDoctypeConfig.this.factoryByIdx.put(wsettype.idx(), () -> new WeightedSetDataType(ApplyNewDoctypeConfig.this.getOrCreateType(wsettype.elementtype()), wsettype.createifnonexistent(), wsettype.removeifzero()));
                }
                for (DocumentmanagerConfig.Doctype.Documentref documentref : this.docTypeConfig.documentref()) {
                    ApplyNewDoctypeConfig.this.factoryByIdx.put(documentref.idx(), () -> ReferenceDataType.createWithInferredId(ApplyNewDoctypeConfig.this.inProgressById.get((Object)Integer.valueOf((int)typeconf.targettype())).docType));
                }
                for (DocumentmanagerConfig.Doctype.Annotationref annotationref : this.docTypeConfig.annotationref()) {
                    ApplyNewDoctypeConfig.this.factoryByIdx.put(annotationref.idx(), () -> new AnnotationReferenceDataType(this.annTypeFromIdx(annotationref.annotationtype())));
                }
            }

            boolean isPositionStruct(DocumentmanagerConfig.Doctype.Structtype cfg) {
                if (!cfg.name().equals("position")) {
                    return false;
                }
                if (!cfg.inherits().isEmpty()) {
                    return false;
                }
                if (cfg.field().size() != 2) {
                    return false;
                }
                DocumentmanagerConfig.Doctype.Structtype.Field f0 = cfg.field(0);
                DocumentmanagerConfig.Doctype.Structtype.Field f1 = cfg.field(1);
                if (!f0.name().equals(this.POS_X.getName())) {
                    return false;
                }
                if (!f1.name().equals(this.POS_Y.getName())) {
                    return false;
                }
                if (f0.internalid() != this.POS_X.getId()) {
                    return false;
                }
                if (f1.internalid() != this.POS_Y.getId()) {
                    return false;
                }
                if (ApplyNewDoctypeConfig.this.typesByIdx.get(f0.type()) != this.POS_X.getDataType()) {
                    return false;
                }
                return ApplyNewDoctypeConfig.this.typesByIdx.get(f1.type()) == this.POS_Y.getDataType();
            }

            void createEmptyStructs() {
                for (DocumentmanagerConfig.Doctype.Structtype typeconf : this.docTypeConfig.structtype()) {
                    if (this.isPositionStruct(typeconf)) {
                        int geoVersion = ApplyNewDoctypeConfig.this.usev8geopositions ? 8 : 7;
                        ApplyNewDoctypeConfig.this.addNewType(typeconf.idx(), new GeoPosType(geoVersion));
                        continue;
                    }
                    ApplyNewDoctypeConfig.this.addNewType(typeconf.idx(), new StructDataType(typeconf.name()));
                }
            }

            void initializeDocType() {
                HashSet<String> importedFields = new HashSet<String>();
                for (DocumentmanagerConfig.Doctype.Importedfield imported : this.docTypeConfig.importedfield()) {
                    importedFields.add(imported.name());
                }
                int contentIdx = this.docTypeConfig.contentstruct();
                DataType contentStruct = ApplyNewDoctypeConfig.this.typesByIdx.get(contentIdx);
                if (!(contentStruct instanceof StructDataType)) {
                    throw new IllegalArgumentException("Content struct for document type " + this.docTypeConfig.name() + " should be a struct, but was: " + String.valueOf(contentStruct));
                }
                this.docType = this.docTypeConfig.name().equals(DataType.DOCUMENT.getName()) ? DataType.DOCUMENT : new DocumentType(this.docTypeConfig.name(), (StructDataType)contentStruct, importedFields);
                ApplyNewDoctypeConfig.this.addNewType(this.docTypeConfig.idx(), this.docType);
            }

            void createEmptyAnnotationTypes() {
                for (DocumentmanagerConfig.Doctype.Annotationtype typeconf : this.docTypeConfig.annotationtype()) {
                    AnnotationType annType = ApplyNewDoctypeConfig.this.manager.getAnnotationTypeRegistry().getType(typeconf.name());
                    if (typeconf.internalid() != -1) {
                        if (annType == null) {
                            annType = new AnnotationType(typeconf.name(), typeconf.internalid());
                        } else if (annType.getId() != typeconf.internalid()) {
                            throw new IllegalArgumentException("Wrong internalid for annotation type " + String.valueOf(annType) + " (wanted " + typeconf.internalid() + ", got " + annType.getId() + ")");
                        }
                    } else if (annType == null) {
                        annType = new AnnotationType(typeconf.name());
                    }
                    ApplyNewDoctypeConfig.this.manager.getAnnotationTypeRegistry().register(annType);
                    AnnotationReferenceDataType proxy = new AnnotationReferenceDataType(annType);
                    ApplyNewDoctypeConfig.this.proxyRefs.add(typeconf.idx());
                    ApplyNewDoctypeConfig.this.addNewType(typeconf.idx(), proxy);
                }
            }

            AnnotationType annTypeFromIdx(int idx) {
                AnnotationReferenceDataType proxy = (AnnotationReferenceDataType)ApplyNewDoctypeConfig.this.typesByIdx.get(idx);
                if (proxy == null) {
                    throw new IllegalArgumentException("Needed AnnotationType for idx " + idx + ", found: " + String.valueOf(ApplyNewDoctypeConfig.this.typesByIdx.get(idx)));
                }
                return proxy.getAnnotationType();
            }

            void fillAnnotationTypes() {
                for (DocumentmanagerConfig.Doctype.Annotationtype typeConf : this.docTypeConfig.annotationtype()) {
                    AnnotationType annType = this.annTypeFromIdx(typeConf.idx());
                    int pIdx = typeConf.datatype();
                    if (pIdx != -1) {
                        DataType payload = ApplyNewDoctypeConfig.this.getOrCreateType(pIdx);
                        annType.setDataType(payload);
                    }
                    for (DocumentmanagerConfig.Doctype.Annotationtype.Inherits inherit : typeConf.inherits()) {
                        AnnotationType inheritedType = this.annTypeFromIdx(inherit.idx());
                        if (annType.inherits(inheritedType)) continue;
                        annType.inherit(inheritedType);
                    }
                }
            }

            void fillStructs() {
                for (DocumentmanagerConfig.Doctype.Structtype structCfg : this.docTypeConfig.structtype()) {
                    if (this.isPositionStruct(structCfg)) continue;
                    int idx = structCfg.idx();
                    StructDataType type = (StructDataType)ApplyNewDoctypeConfig.this.typesByIdx.get(idx);
                    for (DocumentmanagerConfig.Doctype.Structtype.Inherits parent : structCfg.inherits()) {
                        StructDataType parentStruct = (StructDataType)ApplyNewDoctypeConfig.this.typesByIdx.get(parent.type());
                        type.inherit(parentStruct);
                    }
                    for (DocumentmanagerConfig.Doctype.Structtype.Field fieldCfg : structCfg.field()) {
                        if (fieldCfg.type() == idx) {
                            log.fine("Self-referencing struct " + structCfg.name() + " field: " + String.valueOf((Object)fieldCfg));
                        }
                        DataType fieldType = ApplyNewDoctypeConfig.this.getOrCreateType(fieldCfg.type());
                        type.addField(new Field(fieldCfg.name(), fieldCfg.internalid(), fieldType));
                    }
                    if (this.docType == DataType.DOCUMENT) continue;
                    this.docType.addDeclaredStructType(structCfg.name(), type);
                }
            }

            void fillDocument() {
                for (Object inherit : this.docTypeConfig.inherits()) {
                    PerDocTypeData perDocTypeData = ApplyNewDoctypeConfig.this.inProgressById.get(inherit.idx());
                    if (perDocTypeData == null) {
                        throw new IllegalArgumentException("Missing doctype for inherit idx: " + inherit.idx());
                    }
                    this.docType.inherit(perDocTypeData.docType);
                }
                HashMap<String, Collection<String>> fieldSets = new HashMap<String, Collection<String>>();
                for (Map.Entry entry : this.docTypeConfig.fieldsets().entrySet()) {
                    fieldSets.put((String)entry.getKey(), ((DocumentmanagerConfig.Doctype.Fieldsets)((Object)entry.getValue())).fields());
                }
                HashSet<String> importedFields = new HashSet<String>();
                for (DocumentmanagerConfig.Doctype.Importedfield imported : this.docTypeConfig.importedfield()) {
                    importedFields.add(imported.name());
                }
                this.docType.addFieldSets(fieldSets);
            }
        }
    }
}

