/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.api.annotations.Beta;
import java.util.Objects;
import java.util.Optional;

public class TestAndSetCondition {
    public static final TestAndSetCondition NOT_PRESENT_CONDITION = new TestAndSetCondition();
    private final String conditionStr;
    private final long requiredTimestamp;

    public TestAndSetCondition() {
        this("");
    }

    public TestAndSetCondition(String conditionStr) {
        this.conditionStr = conditionStr;
        this.requiredTimestamp = 0L;
    }

    private TestAndSetCondition(long requiredTimestamp, String conditionStr) {
        this.conditionStr = conditionStr;
        this.requiredTimestamp = requiredTimestamp;
    }

    private TestAndSetCondition(long requiredTimestamp) {
        this.conditionStr = "";
        this.requiredTimestamp = requiredTimestamp;
    }

    public String getSelection() {
        return this.conditionStr;
    }

    @Beta
    public long requiredTimestamp() {
        return this.requiredTimestamp;
    }

    public boolean isPresent() {
        return !this.conditionStr.isEmpty() || this.requiredTimestamp != 0L;
    }

    public static TestAndSetCondition fromConditionString(Optional<String> conditionString) {
        return conditionString.map(TestAndSetCondition::new).orElse(NOT_PRESENT_CONDITION);
    }

    @Beta
    public static TestAndSetCondition ofRequiredTimestampWithSelectionFallback(long requiredTimestamp, String selectionFallback) {
        return new TestAndSetCondition(requiredTimestamp, selectionFallback);
    }

    @Beta
    public static TestAndSetCondition ofRequiredTimestamp(long requiredTimestamp) {
        return new TestAndSetCondition(requiredTimestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestAndSetCondition that = (TestAndSetCondition)o;
        return this.requiredTimestamp == that.requiredTimestamp && Objects.equals(this.conditionStr, that.conditionStr);
    }

    public int hashCode() {
        return Objects.hash(this.conditionStr, this.requiredTimestamp);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("condition '");
        string.append(this.conditionStr);
        string.append("'");
        if (this.requiredTimestamp != 0L) {
            string.append(", required_timestamp ");
            string.append(Long.toUnsignedString(this.requiredTimestamp));
        }
        return string.toString();
    }
}

