/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.tensor.TensorType;
import java.util.Objects;

public class TensorDataType
extends DataType {
    public static int classId = TensorDataType.registerClass((int)4155, TensorDataType.class);
    private static final TensorDataType anyTensorDataType = new TensorDataType(null);
    private final TensorType tensorType;

    public TensorDataType(TensorType tensorType) {
        super(tensorType == null ? "tensor" : tensorType.toString(), 21);
        this.tensorType = tensorType;
    }

    @Override
    public TensorDataType clone() {
        return (TensorDataType)super.clone();
    }

    @Override
    public FieldValue createFieldValue() {
        return new TensorFieldValue(this.tensorType);
    }

    @Override
    public Class<? extends TensorFieldValue> getValueClass() {
        return TensorFieldValue.class;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (value == null) {
            return false;
        }
        if (this.tensorType == null) {
            return true;
        }
        if (!TensorFieldValue.class.isAssignableFrom(value.getClass())) {
            return false;
        }
        TensorFieldValue tensorValue = (TensorFieldValue)value;
        return tensorValue.getDataType().getTensorType().isConvertibleTo(this.tensorType);
    }

    public TensorType getTensorType() {
        return this.tensorType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TensorDataType that = (TensorDataType)o;
        return Objects.equals(this.tensorType, that.tensorType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tensorType);
    }

    public static TensorDataType any() {
        return anyTensorDataType;
    }
}

