/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select;

import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.rule.AttributeNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class ResultList {
    private final List<ResultPair> results = new ArrayList<ResultPair>();

    public ResultList() {
    }

    public ResultList(Result result) {
        this.add(new FieldPathIteratorHandler.VariableMap(), result);
    }

    public void add(FieldPathIteratorHandler.VariableMap variables, Result result) {
        this.results.add(new ResultPair(variables, result));
    }

    public List<ResultPair> getResults() {
        return this.results;
    }

    public static ResultList fromBoolean(boolean result) {
        return new ResultList(result ? Result.TRUE : Result.FALSE);
    }

    public Result toResult() {
        if (this.results.isEmpty()) {
            return Result.FALSE;
        }
        boolean foundFalse = false;
        for (ResultPair rp : this.results) {
            if (rp.result == Result.TRUE) {
                return Result.TRUE;
            }
            if (rp.result != Result.FALSE) continue;
            foundFalse = true;
        }
        if (foundFalse) {
            return Result.FALSE;
        }
        return Result.INVALID;
    }

    private static boolean combineVariables(FieldPathIteratorHandler.VariableMap output, FieldPathIteratorHandler.VariableMap input) {
        FieldPathIteratorHandler.IndexValue found;
        for (Map.Entry entry : output.entrySet()) {
            found = (FieldPathIteratorHandler.IndexValue)input.get(entry.getKey());
            if (found == null || found.equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : input.entrySet()) {
            found = (FieldPathIteratorHandler.IndexValue)output.get(entry.getKey());
            if (found == null || found.equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : input.entrySet()) {
            output.put((String)entry.getKey(), (FieldPathIteratorHandler.IndexValue)entry.getValue());
        }
        return true;
    }

    public ResultList combineAND(LazyResultList other) {
        if (Result.FALSE == this.toResult()) {
            return ResultList.toResultList(false);
        }
        return this.combineBinaryOp(other, ResultList::combineAND);
    }

    private static Result combineAND(Result lhs, Result rhs) {
        if (lhs == Result.TRUE && rhs == Result.TRUE) {
            return Result.TRUE;
        }
        if (lhs == Result.FALSE || rhs == Result.FALSE) {
            return Result.FALSE;
        }
        return Result.INVALID;
    }

    public ResultList combineOR(LazyResultList other) {
        if (Result.TRUE == this.toResult()) {
            return ResultList.toResultList(true);
        }
        return this.combineBinaryOp(other, ResultList::combineOR);
    }

    private ResultList combineBinaryOp(LazyResultList other, BiFunction<Result, Result, Result> op) {
        ResultList result = new ResultList();
        EnumSet<Result> observedNoVarResults = EnumSet.noneOf(Result.class);
        for (ResultPair pair : this.results) {
            for (ResultPair otherPair : other.getResult().results) {
                if (pair.variables.isEmpty() && otherPair.variables.isEmpty()) {
                    observedNoVarResults.add(op.apply(pair.result, otherPair.result));
                    continue;
                }
                FieldPathIteratorHandler.VariableMap varMap = (FieldPathIteratorHandler.VariableMap)pair.variables.clone();
                if (!ResultList.combineVariables(varMap, otherPair.variables)) continue;
                result.add(varMap, op.apply(pair.result, otherPair.result));
            }
        }
        for (Result mergedResult : observedNoVarResults) {
            result.add(new FieldPathIteratorHandler.VariableMap(), mergedResult);
        }
        return result;
    }

    private static Result combineOR(Result lhs, Result rhs) {
        if (lhs == Result.TRUE || rhs == Result.TRUE) {
            return Result.TRUE;
        }
        if (lhs == Result.FALSE && rhs == Result.FALSE) {
            return Result.FALSE;
        }
        return Result.INVALID;
    }

    public static ResultList toResultList(Object value) {
        if (value instanceof ResultList) {
            return (ResultList)value;
        }
        if (value instanceof AttributeNode.VariableValueList) {
            ResultList retVal = new ResultList();
            for (VariableValue vv : (AttributeNode.VariableValueList)value) {
                retVal.add(vv.getVariables(), Result.TRUE);
            }
            return retVal;
        }
        if (value == null || value == Result.FALSE || value == Boolean.FALSE || value instanceof Number && ((Number)value).doubleValue() == 0.0) {
            return new ResultList(Result.FALSE);
        }
        if (value == Result.INVALID) {
            return new ResultList(Result.INVALID);
        }
        return new ResultList(Result.TRUE);
    }

    public String toString() {
        return this.results.toString();
    }

    public static class ResultPair {
        FieldPathIteratorHandler.VariableMap variables;
        Result result;

        ResultPair(FieldPathIteratorHandler.VariableMap var, Result res) {
            this.variables = var;
            this.result = res;
        }

        public FieldPathIteratorHandler.VariableMap getVariables() {
            return this.variables;
        }

        public Result getResult() {
            return this.result;
        }

        public String toString() {
            return this.variables.toString() + " => " + this.result;
        }
    }

    public static interface LazyResultList {
        public ResultList getResult();
    }

    public static class VariableValue {
        FieldPathIteratorHandler.VariableMap variables;
        Object value;

        public VariableValue(FieldPathIteratorHandler.VariableMap vars, Object value) {
            this.variables = vars;
            this.value = value;
        }

        public FieldPathIteratorHandler.VariableMap getVariables() {
            return this.variables;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.variables.toString() + " => " + this.value;
        }
    }
}

