/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.DocumentId;

public class BucketId
implements Comparable<BucketId> {
    public static final int COUNT_BITS = 6;
    private long id = 0L;
    private static final long[] usedMask = new long[59];

    public BucketId() {
    }

    public BucketId(long id) {
        this.id = id;
    }

    public BucketId(int usedBits, long id) {
        long usedMask = (long)usedBits << 58;
        id <<= 6;
        this.id = (id >>>= 6) | usedMask;
    }

    public BucketId(String serialized) {
        if (!serialized.startsWith("BucketId(0x")) {
            throw new IllegalArgumentException("Serialized bucket id must start with 'BucketId(0x'");
        }
        if (!serialized.endsWith(")")) {
            throw new IllegalArgumentException("Serialized bucket id must end with ')'");
        }
        long id = 0L;
        for (int index = 11; index < serialized.length() - 1; ++index) {
            char c = serialized.charAt(index);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                throw new IllegalArgumentException("Serialized bucket id (" + serialized + ") contains illegal character at position " + index);
            }
            id <<= 4;
            id += (long)Integer.parseInt(String.valueOf(c), 16);
        }
        this.id = id;
        if (this.getUsedBits() == 0) {
            throw new IllegalArgumentException("Created bucket id " + id + ", but no countbits are set");
        }
    }

    public boolean equals(Object o) {
        return o instanceof BucketId && ((BucketId)o).getId() == this.getId();
    }

    @Override
    public int compareTo(BucketId other) {
        if (this.id >>> 32 == other.id >>> 32) {
            if ((this.id & 0xFFFFFFFFL) > (other.id & 0xFFFFFFFFL)) {
                return 1;
            }
            if ((this.id & 0xFFFFFFFFL) < (other.id & 0xFFFFFFFFL)) {
                return -1;
            }
            return 0;
        }
        if (this.id >>> 32 > other.id >>> 32) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public int getUsedBits() {
        return (int)(this.id >>> 58);
    }

    public long getRawId() {
        return this.id;
    }

    public long getId() {
        int notUsed = 64 - this.getUsedBits();
        long usedMask = -1L << notUsed >>> notUsed;
        long countMask = -288230376151711744L;
        return this.id & (usedMask | countMask);
    }

    public long withoutCountBits() {
        return this.id & usedMask[this.getUsedBits()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("BucketId(0x");
        String number = Long.toHexString(this.getId());
        for (int i = number.length(); i < 16; ++i) {
            sb.append('0');
        }
        sb.append(number).append(')');
        return sb.toString();
    }

    public boolean contains(BucketId id) {
        if (id.getUsedBits() < this.getUsedBits()) {
            return false;
        }
        BucketId copy = new BucketId(this.getUsedBits(), id.getRawId());
        return copy.getId() == this.getId();
    }

    public boolean contains(DocumentId docId, BucketIdFactory factory) {
        return this.contains(factory.getBucketId(docId));
    }

    static {
        long val = 0L;
        for (int i = 0; i < usedMask.length; ++i) {
            BucketId.usedMask[i] = val;
            val = val << 1 | 1L;
        }
    }
}

