/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.json.JsonReaderException;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.SingleValueReader;

public class StructReader {
    public static void fillStruct(TokenBuffer buffer, StructuredFieldValue parent, boolean ignoreUndefinedFields) {
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            Field field = StructReader.getField(buffer, parent, ignoreUndefinedFields);
            try {
                if (field != null && buffer.currentToken() != JsonToken.VALUE_NULL) {
                    FieldValue v = SingleValueReader.readSingleValue(buffer, field.getDataType(), ignoreUndefinedFields);
                    parent.setFieldValue(field, v);
                }
                buffer.next();
            }
            catch (IllegalArgumentException e) {
                throw new JsonReaderException(field, (Throwable)e);
            }
        }
    }

    private static Field getField(TokenBuffer buffer, StructuredFieldValue parent, boolean ignoreUndefinedFields) {
        Field field = parent.getField(buffer.currentName());
        if (field == null && !ignoreUndefinedFields) {
            throw new IllegalArgumentException("No field '" + buffer.currentName() + "' in the structure of type '" + parent.getDataType().getDataTypeName() + "', which has the fields: " + parent.getDataType().getFields());
        }
        return field;
    }
}

