/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public class BoolFieldValue
extends FieldValue {
    public static final int classId = BoolFieldValue.registerClass((int)4113, BoolFieldValue.class);
    private boolean value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public BoolFieldValue() {
        this(false);
    }

    public BoolFieldValue(boolean value) {
        this.value = value;
    }

    public BoolFieldValue(String s) {
        this.value = Boolean.parseBoolean(s);
    }

    @Override
    public BoolFieldValue clone() {
        return (BoolFieldValue)super.clone();
    }

    @Override
    public void clear() {
        this.value = false;
    }

    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof String || o instanceof StringFieldValue) {
            this.value = Boolean.parseBoolean(o.toString());
        } else if (o instanceof Boolean) {
            this.value = (Boolean)o;
        } else if (o instanceof BoolFieldValue) {
            this.value = ((BoolFieldValue)o).value;
        } else {
            throw new IllegalArgumentException("Class " + o.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public boolean getBoolean() {
        return this.value;
    }

    public void setBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printBoolXml(this, xml);
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        return super.hashCode() + (this.value ? 3 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoolFieldValue)) {
            return false;
        }
        BoolFieldValue other = (BoolFieldValue)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.value == other.value;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue other) {
        int comp = super.compareTo(other);
        if (comp != 0) {
            return comp;
        }
        return Boolean.compare(this.value, ((BoolFieldValue)other).value);
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new BoolFieldValue();
        }

        @Override
        public FieldValue create(String value) {
            return new BoolFieldValue(value);
        }
    }
}

