/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Supplier;

public class TokenBuffer {
    final Deque<Token> tokens = new ArrayDeque<Token>();
    private int nesting = 0;

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public JsonToken next() {
        this.advance();
        JsonToken token = this.current();
        this.updateNesting(token);
        return token;
    }

    void advance() {
        this.tokens.poll();
    }

    public JsonToken current() {
        return this.isEmpty() ? null : this.tokens.peek().token;
    }

    public String currentName() {
        return this.isEmpty() ? null : this.tokens.peek().name;
    }

    public String currentText() {
        return this.isEmpty() ? null : this.tokens.peek().text;
    }

    public Supplier<Token> lookahead() {
        Iterator<Token> iterator = this.tokens.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return () -> iterator.hasNext() ? (Token)iterator.next() : null;
    }

    private void add(JsonToken token, String name, String text) {
        this.tokens.add(new Token(token, name, text));
    }

    public void bufferObject(JsonParser parser) {
        this.bufferJsonStruct(parser, JsonToken.START_OBJECT);
    }

    private void bufferJsonStruct(JsonParser parser, JsonToken firstToken) {
        JsonToken token = parser.currentToken();
        Preconditions.checkArgument((token == firstToken ? 1 : 0) != 0, (String)"Expected %s, got %s.", (Object)firstToken.name(), (Object)token);
        this.updateNesting(token);
        try {
            for (int nesting = this.addFromParser(parser); nesting > 0; nesting += this.addFromParser(parser)) {
                parser.nextValue();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    int nestingOffset(JsonToken token) {
        if (token == null) {
            return 0;
        }
        if (token.isStructStart()) {
            return 1;
        }
        if (token.isStructEnd()) {
            return -1;
        }
        return 0;
    }

    int addFromParser(JsonParser tokens) throws IOException {
        this.add(tokens.currentToken(), tokens.getCurrentName(), tokens.getText());
        return this.nestingOffset(tokens.currentToken());
    }

    void updateNesting(JsonToken token) {
        this.nesting += this.nestingOffset(token);
    }

    public int nesting() {
        return this.nesting;
    }

    public void skipToRelativeNesting(int relativeNesting) {
        int initialNesting = this.nesting();
        do {
            this.next();
        } while (this.nesting() > initialNesting + relativeNesting);
    }

    public static final class Token {
        public final JsonToken token;
        public final String name;
        public final String text;

        Token(JsonToken token, String name, String text) {
            this.token = token;
            this.name = name;
            this.text = text;
        }

        public String toString() {
            return "Token(" + this.token + ", " + this.name + ", " + this.text + ")";
        }
    }
}

