/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.google.common.collect.ImmutableMultiset;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.annotation.AlternateSpanList;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationContainer;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationType2AnnotationContainer;
import com.yahoo.document.annotation.DummySpanNode;
import com.yahoo.document.annotation.ListAnnotationContainer;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanNode2AnnotationContainer;
import com.yahoo.document.annotation.SpanNodeParent;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;

public class SpanTree
implements Iterable<Annotation>,
SpanNodeParent,
Comparable<SpanTree> {
    private String name;
    private SpanNode root;
    private AnnotationContainer annotations = new ListAnnotationContainer();
    private StringFieldValue stringFieldValue;

    public SpanTree() {
    }

    public SpanTree(String name, SpanNode root) {
        this.name = name;
        this.setRoot(root);
    }

    public SpanTree(String name) {
        this.name = name;
        this.setRoot(new SpanList());
    }

    public SpanTree(SpanTree otherToCopy) {
        this.name = otherToCopy.name;
        this.setRoot(this.copySpan(otherToCopy.root));
        ArrayList<Annotation> annotationsToCopy = new ArrayList<Annotation>(otherToCopy.getAnnotations());
        ArrayList<Annotation> newAnnotations = new ArrayList<Annotation>(annotationsToCopy.size());
        for (Annotation otherAnnotationToCopy : annotationsToCopy) {
            newAnnotations.add(new Annotation(otherAnnotationToCopy));
        }
        IdentityHashMap<SpanNode, Integer> originalSpanNodes = SpanTree.getSpanNodes(otherToCopy);
        List<SpanNode> copySpanNodes = this.getSpanNodes();
        for (int i = 0; i < annotationsToCopy.size(); ++i) {
            Annotation originalAnnotation = (Annotation)annotationsToCopy.get(i);
            if (!originalAnnotation.isSpanNodeValid()) continue;
            Integer indexOfOriginalSpanNode = originalSpanNodes.get(originalAnnotation.getSpanNode());
            if (indexOfOriginalSpanNode == null) {
                throw new IllegalStateException("Could not clone tree, SpanNode of " + originalAnnotation + " not found.");
            }
            ((Annotation)newAnnotations.get(i)).setSpanNode(copySpanNodes.get(indexOfOriginalSpanNode));
        }
        IdentityHashMap<Annotation, Integer> originalAnnotations = this.getAnnotations(annotationsToCopy);
        for (Annotation a : newAnnotations) {
            if (!a.hasFieldValue()) continue;
            this.setCorrectAnnotationReference(a.getFieldValue(), originalAnnotations, newAnnotations);
        }
        for (Annotation a : newAnnotations) {
            this.annotate(a);
        }
        for (IndexKey key : otherToCopy.getCurrentIndexes()) {
            this.createIndex(key);
        }
    }

    private void setCorrectAnnotationReference(FieldValue value, IdentityHashMap<Annotation, Integer> originalAnnotations, List<Annotation> newAnnotations) {
        if (value == null) {
            return;
        }
        if (value.getDataType() instanceof AnnotationReferenceDataType) {
            AnnotationReference ref = (AnnotationReference)value;
            if (ref.getReference() == null) {
                return;
            }
            Integer referenceIndex = originalAnnotations.get(ref.getReference());
            if (referenceIndex == null) {
                throw new IllegalStateException("Cannot find Annotation pointed to by " + ref);
            }
            try {
                Annotation newReference = newAnnotations.get(referenceIndex);
                ref.setReference(newReference);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new IllegalStateException("Cannot find Annotation pointed to by " + ref, ioobe);
            }
        } else if (value.getDataType() instanceof StructuredDataType) {
            this.setCorrectAnnotationReference((StructuredFieldValue)value, originalAnnotations, newAnnotations);
        } else if (value.getDataType() instanceof CollectionDataType) {
            this.setCorrectAnnotationReference((CollectionFieldValue)value, originalAnnotations, newAnnotations);
        } else if (value.getDataType() instanceof MapDataType) {
            this.setCorrectAnnotationReference((MapFieldValue)value, originalAnnotations, newAnnotations);
        }
    }

    private void setCorrectAnnotationReference(StructuredFieldValue struct, IdentityHashMap<Annotation, Integer> originalAnnotations, List<Annotation> newAnnotations) {
        for (Field f : struct.getDataType().getFields()) {
            this.setCorrectAnnotationReference(struct.getFieldValue(f), originalAnnotations, newAnnotations);
        }
    }

    private void setCorrectAnnotationReference(CollectionFieldValue collection, IdentityHashMap<Annotation, Integer> originalAnnotations, List<Annotation> newAnnotations) {
        Iterator it = collection.fieldValueIterator();
        while (it.hasNext()) {
            this.setCorrectAnnotationReference((FieldValue)it.next(), originalAnnotations, newAnnotations);
        }
    }

    private void setCorrectAnnotationReference(MapFieldValue map, IdentityHashMap<Annotation, Integer> originalAnnotations, List<Annotation> newAnnotations) {
        for (Object o : map.values()) {
            this.setCorrectAnnotationReference((FieldValue)o, originalAnnotations, newAnnotations);
        }
    }

    private IdentityHashMap<Annotation, Integer> getAnnotations(List<Annotation> annotationsToCopy) {
        IdentityHashMap<Annotation, Integer> map = new IdentityHashMap<Annotation, Integer>();
        for (int i = 0; i < annotationsToCopy.size(); ++i) {
            map.put(annotationsToCopy.get(i), i);
        }
        return map;
    }

    private List<SpanNode> getSpanNodes() {
        ArrayList<SpanNode> nodes = new ArrayList<SpanNode>();
        nodes.add(this.root);
        ListIterator<SpanNode> it = this.root.childIteratorRecursive();
        while (it.hasNext()) {
            nodes.add((SpanNode)it.next());
        }
        return nodes;
    }

    private static IdentityHashMap<SpanNode, Integer> getSpanNodes(SpanTree otherToCopy) {
        IdentityHashMap<SpanNode, Integer> map = new IdentityHashMap<SpanNode, Integer>();
        int spanNodeCounter = 0;
        map.put(otherToCopy.getRoot(), spanNodeCounter++);
        ListIterator<SpanNode> it = otherToCopy.getRoot().childIteratorRecursive();
        while (it.hasNext()) {
            map.put((SpanNode)it.next(), spanNodeCounter++);
        }
        return map;
    }

    private SpanNode copySpan(SpanNode spanTree) {
        if (spanTree instanceof Span) {
            return new Span((Span)spanTree);
        }
        if (spanTree instanceof AlternateSpanList) {
            return new AlternateSpanList((AlternateSpanList)spanTree);
        }
        if (spanTree instanceof SpanList) {
            return new SpanList((SpanList)spanTree);
        }
        if (spanTree instanceof DummySpanNode) {
            return spanTree;
        }
        throw new IllegalStateException("Cannot create copy of " + spanTree + " with class " + (Serializable)(spanTree == null ? "null" : spanTree.getClass()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoot(SpanNode root) {
        if (!root.isValid()) {
            throw new IllegalStateException("Cannot use invalid node " + root + " as root node.");
        }
        if (root.getParent() != null && root.getParent() != this) {
            throw new IllegalStateException(root + " is already a child of " + root.getParent() + ", cannot be root of " + this);
        }
        this.root = root;
        root.setParent(this);
    }

    public String getName() {
        return this.name;
    }

    public SpanNode getRoot() {
        return this.root;
    }

    public SpanList spanList() {
        return (SpanList)this.root;
    }

    public void cleanup() {
        Map<Annotation, Annotation> removedAnnotations = this.removeAnnotationsThatPointToInvalidSpanNodes();
        if (!removedAnnotations.isEmpty()) {
            Iterator<Annotation> annotationIt = this.iterator();
            while (annotationIt.hasNext()) {
                AnnotationReference ref;
                FieldValue value;
                Annotation a = annotationIt.next();
                if (!a.hasFieldValue() || !((value = a.getFieldValue()) instanceof AnnotationReference) || removedAnnotations.get((ref = (AnnotationReference)value).getReference()) == null) continue;
                ref.setReference(null);
                a.setFieldValue(null);
                if (a.isSpanNodeValid()) continue;
                annotationIt.remove();
                removedAnnotations.put(a, a);
            }
        }
        if (!removedAnnotations.isEmpty()) {
            for (Annotation a : this) {
                if (!a.hasFieldValue()) continue;
                this.removeObsoleteReferencesFromFieldValue(a.getFieldValue(), removedAnnotations, true);
            }
        }
        this.removeAnnotationReferencesThatPointToRemovedAnnotations();
    }

    private boolean removeObsoleteReferencesFromFieldValue(FieldValue value, Map<Annotation, Annotation> selectedAnnotations, boolean removeIfPresent) {
        if (value == null) {
            return false;
        }
        if (value.getDataType() instanceof AnnotationReferenceDataType) {
            AnnotationReference ref = (AnnotationReference)value;
            if (removeIfPresent) {
                if (selectedAnnotations.containsValue(ref.getReference())) {
                    ref.setReference(null);
                    return true;
                }
            } else if (!selectedAnnotations.containsValue(ref.getReference())) {
                ref.setReference(null);
                return true;
            }
        } else if (value.getDataType() instanceof StructuredDataType) {
            this.removeObsoleteReferencesFromStructuredType((StructuredFieldValue)value, selectedAnnotations, removeIfPresent);
        } else if (value.getDataType() instanceof CollectionDataType) {
            this.removeObsoleteReferencesFromCollectionType((CollectionFieldValue)value, selectedAnnotations, removeIfPresent);
        } else if (value.getDataType() instanceof MapDataType) {
            this.removeObsoleteReferencesFromMapType((MapFieldValue)value, selectedAnnotations, removeIfPresent);
        }
        return false;
    }

    private boolean removeObsoleteReferencesFromStructuredType(StructuredFieldValue struct, Map<Annotation, Annotation> selectedAnnotations, boolean removeIfPresent) {
        for (Field f : struct.getDataType().getFields()) {
            FieldValue fValue = struct.getFieldValue(f);
            if (!this.removeObsoleteReferencesFromFieldValue(fValue, selectedAnnotations, removeIfPresent)) continue;
            struct.removeFieldValue(f);
        }
        return false;
    }

    private boolean removeObsoleteReferencesFromCollectionType(CollectionFieldValue collection, Map<Annotation, Annotation> selectedAnnotations, boolean removeIfPresent) {
        Iterator it = collection.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue fValue = (FieldValue)it.next();
            if (!this.removeObsoleteReferencesFromFieldValue(fValue, selectedAnnotations, removeIfPresent)) continue;
            it.remove();
        }
        return false;
    }

    private boolean removeObsoleteReferencesFromMapType(MapFieldValue map, Map<Annotation, Annotation> selectedAnnotations, boolean removeIfPresent) {
        Iterator valueIt = map.values().iterator();
        while (valueIt.hasNext()) {
            FieldValue fValue = (FieldValue)valueIt.next();
            if (!this.removeObsoleteReferencesFromFieldValue(fValue, selectedAnnotations, removeIfPresent)) continue;
            valueIt.remove();
        }
        return false;
    }

    private Map<Annotation, Annotation> removeAnnotationsThatPointToInvalidSpanNodes() {
        IdentityHashMap<Annotation, Annotation> removedAnnotations = new IdentityHashMap<Annotation, Annotation>();
        Iterator<Annotation> annotationIt = this.iterator();
        while (annotationIt.hasNext()) {
            Annotation a = annotationIt.next();
            if (!a.hasSpanNode() || a.isSpanNodeValid()) continue;
            a.setSpanNode(null);
            a.setFieldValue(null);
            removedAnnotations.put(a, a);
            annotationIt.remove();
        }
        return removedAnnotations;
    }

    private boolean hasAnyFieldValues() {
        for (Annotation a : this) {
            if (!a.hasFieldValue()) continue;
            return true;
        }
        return false;
    }

    private void removeAnnotationReferencesThatPointToRemovedAnnotations() {
        if (this.hasAnyFieldValues()) {
            IdentityHashMap<Annotation, Annotation> annotationsStillPresent = new IdentityHashMap<Annotation, Annotation>();
            for (Annotation a : this) {
                annotationsStillPresent.put(a, a);
            }
            for (Annotation a : this) {
                if (!a.hasFieldValue()) continue;
                this.removeObsoleteReferencesFromFieldValue(a.getFieldValue(), annotationsStillPresent, false);
            }
        }
    }

    private void annotateInternal(SpanNode node, Annotation annotation) {
        this.annotations.annotate(annotation);
    }

    private Collection<Annotation> getAnnotations() {
        return this.annotations.annotations();
    }

    public SpanTree annotate(Annotation a) {
        if (a.getSpanNode() == null) {
            this.annotateInternal(DummySpanNode.INSTANCE, a);
        } else {
            this.annotateInternal(a.getSpanNode(), a);
        }
        return this;
    }

    public SpanTree annotate(SpanNode node, Annotation annotation) {
        annotation.setSpanNode(node);
        return this.annotate(annotation);
    }

    public final SpanTree annotateFast(SpanNode node, Annotation annotation) {
        this.annotateInternal(node, annotation);
        return this;
    }

    public SpanTree annotate(SpanNode node, AnnotationType type, FieldValue value) {
        return this.annotate(node, new Annotation(type, value));
    }

    public SpanTree annotate(SpanNode node, AnnotationType type) {
        Annotation a = new Annotation(type);
        return this.annotate(node, a);
    }

    public boolean remove(Annotation a) {
        return this.getAnnotations().remove(a);
    }

    public int numAnnotations() {
        return this.annotations.annotations().size();
    }

    public void clearAnnotations(SpanNode node) {
        Iterator<Annotation> annIt = this.iterator(node);
        while (annIt.hasNext()) {
            annIt.next();
            annIt.remove();
        }
    }

    public void clearAnnotationsRecursive(SpanNode node) {
        Iterator<Annotation> annIt = this.iteratorRecursive(node);
        while (annIt.hasNext()) {
            annIt.next();
            annIt.remove();
        }
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.annotations.annotations().iterator();
    }

    public Iterator<Annotation> iterator(SpanNode node) {
        return this.annotations.iterator(node);
    }

    public Iterator<Annotation> iteratorRecursive(SpanNode node) {
        return this.annotations.iteratorRecursive(node);
    }

    @Override
    public SpanTree getSpanTree() {
        return this;
    }

    public void setStringFieldValue(StringFieldValue stringFieldValue) {
        this.stringFieldValue = stringFieldValue;
    }

    @Override
    public StringFieldValue getStringFieldValue() {
        return this.stringFieldValue;
    }

    public void createIndex(IndexKey key) {
        if (key == IndexKey.SPAN_NODE && this.annotations instanceof ListAnnotationContainer) {
            SpanNode2AnnotationContainer tmpAnnotations = new SpanNode2AnnotationContainer();
            ((AnnotationContainer)tmpAnnotations).annotateAll(this.annotations.annotations());
            this.annotations = tmpAnnotations;
        } else if (key == IndexKey.ANNOTATION_TYPE && this.annotations instanceof ListAnnotationContainer) {
            AnnotationType2AnnotationContainer tmpAnnotations = new AnnotationType2AnnotationContainer();
            ((AnnotationContainer)tmpAnnotations).annotateAll(this.annotations.annotations());
            this.annotations = tmpAnnotations;
        } else {
            throw new IllegalArgumentException("Multiple indexes not yet supported. Use clearIndex() or clearIndexes() first.");
        }
    }

    public void clearIndex(IndexKey key) {
        if (key == IndexKey.SPAN_NODE && this.annotations instanceof SpanNode2AnnotationContainer) {
            this.clearIndex();
        } else if (key == IndexKey.ANNOTATION_TYPE && this.annotations instanceof AnnotationType2AnnotationContainer) {
            this.clearIndex();
        }
    }

    public void clearIndexes() {
        if (!(this.annotations instanceof ListAnnotationContainer)) {
            this.clearIndex();
        }
    }

    private void clearIndex() {
        ListAnnotationContainer tmpAnnotations = new ListAnnotationContainer();
        ((AnnotationContainer)tmpAnnotations).annotateAll(this.annotations.annotations());
        this.annotations = tmpAnnotations;
    }

    public Collection<IndexKey> getCurrentIndexes() {
        if (this.annotations instanceof AnnotationType2AnnotationContainer) {
            return List.of(IndexKey.ANNOTATION_TYPE);
        }
        if (this.annotations instanceof SpanNode2AnnotationContainer) {
            return List.of(IndexKey.SPAN_NODE);
        }
        return List.of();
    }

    public String toString() {
        return "SpanTree '" + this.name + "' with root: " + this.root + (String)(this.annotations.annotations().size() > 5 ? "" : ", annotations: " + this.annotations.annotations().stream().map(Annotation::toString).collect(Collectors.joining(", ")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanTree)) {
            return false;
        }
        SpanTree tree = (SpanTree)o;
        if (!this.annotationsEquals(tree)) {
            return false;
        }
        if (!this.name.equals(tree.name)) {
            return false;
        }
        return this.root.equals(tree.root);
    }

    private boolean annotationsEquals(SpanTree tree) {
        LinkedList<Annotation> annotationCollection = new LinkedList<Annotation>(this.getAnnotations());
        LinkedList<Annotation> otherAnnotations = new LinkedList<Annotation>(tree.getAnnotations());
        return annotationCollection.size() == otherAnnotations.size() && ImmutableMultiset.copyOf(annotationCollection).equals((Object)ImmutableMultiset.copyOf(otherAnnotations));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.root.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    @Override
    public int compareTo(SpanTree spanTree) {
        int comp = this.name.compareTo(spanTree.name);
        if (comp != 0) {
            comp = this.root.compareTo(spanTree.root);
        }
        return comp;
    }

    public static enum IndexKey {
        SPAN_NODE,
        ANNOTATION_TYPE;

    }
}

