/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;

public class WeightedSetReader {
    public static void fillWeightedSet(TokenBuffer buffer, DataType valueType, WeightedSet weightedSet) {
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectObjectStart(buffer.current());
        buffer.next();
        WeightedSetReader.iterateThroughWeightedSet(buffer, initNesting, valueType, weightedSet);
    }

    public static void fillWeightedSetUpdate(TokenBuffer buffer, int initNesting, DataType valueType, WeightedSet weightedSet) {
        WeightedSetReader.iterateThroughWeightedSet(buffer, initNesting, valueType, weightedSet);
    }

    private static void iterateThroughWeightedSet(TokenBuffer buffer, int initNesting, DataType valueType, WeightedSet weightedSet) {
        while (buffer.nesting() >= initNesting) {
            FieldValue v = valueType.createFieldValue(buffer.currentName());
            weightedSet.put(v, Integer.valueOf(buffer.currentText()));
            buffer.next();
        }
    }
}

