/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.json.JsonReaderException;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.SingleValueReader;

public class StructReader {
    public static boolean fillStruct(TokenBuffer buffer, StructuredFieldValue parent, boolean ignoreUndefinedFields) {
        int initialNesting = buffer.nesting();
        buffer.next();
        boolean fullyApplied = true;
        while (buffer.nesting() >= initialNesting) {
            Field field = parent.getField(buffer.currentName());
            if (field == null) {
                if (!ignoreUndefinedFields) {
                    throw new IllegalArgumentException("No field '" + buffer.currentName() + "' in the structure of type '" + parent.getDataType().getDataTypeName() + "', which has the fields: " + parent.getDataType().getFields());
                }
                buffer.skipToRelativeNesting(1);
                fullyApplied = false;
                continue;
            }
            try {
                if (buffer.current() != JsonToken.VALUE_NULL) {
                    FieldValue v = SingleValueReader.readSingleValue(buffer, field.getDataType(), ignoreUndefinedFields);
                    parent.setFieldValue(field, v);
                }
                buffer.next();
            }
            catch (IllegalArgumentException e) {
                throw new JsonReaderException(field, (Throwable)e);
            }
        }
        return fullyApplied;
    }
}

