/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.PositionDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;

public class GeoPositionReader {
    static void fillGeoPosition(TokenBuffer buffer, FieldValue positionFieldValue) {
        Double latitude = null;
        Double longitude = null;
        JsonParserHelpers.expectObjectStart(buffer.current());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String curName = buffer.currentName();
            if ("lat".equals(curName) || "latitude".equals(curName)) {
                latitude = GeoPositionReader.readDouble(buffer) * 1000000.0;
            } else if ("lng".equals(curName) || "longitude".equals(curName)) {
                longitude = GeoPositionReader.readDouble(buffer) * 1000000.0;
            } else if ("x".equals(curName)) {
                longitude = GeoPositionReader.readDouble(buffer);
            } else if ("y".equals(curName)) {
                latitude = GeoPositionReader.readDouble(buffer);
            } else {
                throw new IllegalArgumentException("Unexpected attribute " + curName + " in geo position field");
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.current());
        if (latitude == null) {
            throw new IllegalArgumentException("Missing 'lat' attribute in geo position field");
        }
        if (longitude == null) {
            throw new IllegalArgumentException("Missing 'lng' attribute in geo position field");
        }
        int y = (int)Math.round(latitude);
        int x = (int)Math.round(longitude);
        Struct geopos = PositionDataType.valueOf(x, y);
        positionFieldValue.assign(geopos);
    }

    private static double readDouble(TokenBuffer buffer) {
        try {
            return Double.parseDouble(buffer.currentText());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a number but got '" + buffer.currentText());
        }
    }
}

