/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Optional;

public class TensorFieldValue
extends FieldValue {
    private Optional<Tensor> tensor;
    private Optional<byte[]> serializedTensor;
    private Optional<TensorDataType> dataType;

    public TensorFieldValue() {
        this.dataType = Optional.empty();
        this.serializedTensor = Optional.empty();
        this.tensor = Optional.empty();
    }

    public TensorFieldValue(TensorType type) {
        this.dataType = Optional.of(new TensorDataType(type));
        this.serializedTensor = Optional.empty();
        this.tensor = Optional.empty();
    }

    public TensorFieldValue(Tensor tensor) {
        this.dataType = Optional.of(new TensorDataType(tensor.type()));
        this.serializedTensor = Optional.empty();
        this.tensor = Optional.of(tensor);
    }

    private void lazyDeserialize() {
        if (this.tensor.isEmpty() && this.serializedTensor.isPresent()) {
            Tensor t = TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])this.serializedTensor.get()));
            Optional<Tensor> newTensor = Optional.of(t);
            this.assignTypeFrom(newTensor);
            this.tensor = newTensor;
        }
    }

    public Optional<Tensor> getTensor() {
        this.lazyDeserialize();
        return this.tensor;
    }

    public Optional<TensorType> getTensorType() {
        if (!this.dataType.isPresent()) {
            this.lazyDeserialize();
        }
        return this.dataType.isPresent() ? Optional.of(this.dataType.get().getTensorType()) : Optional.empty();
    }

    @Override
    public TensorDataType getDataType() {
        return this.dataType.get();
    }

    public String toString() {
        Optional<Tensor> t = this.getTensor();
        if (t.isPresent()) {
            return t.get().toString();
        }
        return "null";
    }

    @Override
    public void printXml(XmlStream xml) {
    }

    @Override
    public void clear() {
        this.tensor = Optional.empty();
        this.serializedTensor = Optional.empty();
    }

    private void assignTypeFrom(Optional<Tensor> newTensor) {
        TensorType curType;
        if (newTensor.isEmpty()) {
            return;
        }
        TensorType newType = newTensor.get().type();
        if (this.dataType.isEmpty()) {
            this.dataType = Optional.of(new TensorDataType(newType));
        }
        if (!newType.isAssignableTo(curType = this.dataType.get().getTensorType())) {
            throw new IllegalArgumentException("Type mismatch: Cannot assign tensor of type " + newType + " to field of type " + curType);
        }
    }

    @Override
    public void assign(Object o) {
        if (o == null) {
            this.assignTensor(Optional.empty());
        } else if (o instanceof Tensor) {
            this.assignTensor(Optional.of((Tensor)o));
        } else if (o instanceof TensorFieldValue) {
            TensorFieldValue tfv = (TensorFieldValue)o;
            this.assignTypeFrom(tfv.tensor);
            this.serializedTensor = tfv.serializedTensor;
            this.tensor = tfv.tensor;
        } else {
            throw new IllegalArgumentException("Expected class '" + this.getClass().getName() + "', got '" + o.getClass().getName() + "'.");
        }
    }

    public void assignSerializedTensor(byte[] data) {
        this.serializedTensor = Optional.of(data);
        this.tensor = Optional.empty();
    }

    public Optional<byte[]> getSerializedTensor() {
        if (this.serializedTensor.isPresent()) {
            return this.serializedTensor;
        }
        if (this.tensor.isPresent()) {
            this.serializedTensor = Optional.of(TypedBinaryFormat.encode((Tensor)this.tensor.get()));
            assert (this.serializedTensor.isPresent());
        }
        return this.serializedTensor;
    }

    public void assignTensor(Optional<Tensor> tensor) {
        this.assignTypeFrom(tensor);
        this.serializedTensor = Optional.empty();
        this.tensor = tensor;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TensorFieldValue)) {
            return false;
        }
        TensorFieldValue other = (TensorFieldValue)o;
        if (!this.getTensorType().equals(other.getTensorType())) {
            return false;
        }
        return this.getTensor().equals(other.getTensor());
    }

    @Override
    public Object getWrappedValue() {
        return this.getTensor().orElse(null);
    }
}

