/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import java.util.ListIterator;

class InvalidatingIterator
implements ListIterator<SpanNode> {
    private SpanList owner;
    private ListIterator<SpanNode> base;
    private SpanNode returnedFromNext = null;

    InvalidatingIterator(SpanList owner, ListIterator<SpanNode> base) {
        this.owner = owner;
        this.base = base;
    }

    @Override
    public boolean hasNext() {
        this.returnedFromNext = null;
        return this.base.hasNext();
    }

    @Override
    public SpanNode next() {
        SpanNode retval = null;
        try {
            retval = this.base.next();
        }
        finally {
            this.returnedFromNext = retval;
        }
        return this.returnedFromNext;
    }

    @Override
    public boolean hasPrevious() {
        this.returnedFromNext = null;
        return this.base.hasPrevious();
    }

    @Override
    public SpanNode previous() {
        this.returnedFromNext = null;
        return this.base.previous();
    }

    @Override
    public int nextIndex() {
        this.returnedFromNext = null;
        return this.base.nextIndex();
    }

    @Override
    public int previousIndex() {
        this.returnedFromNext = null;
        return this.base.previousIndex();
    }

    @Override
    public void remove() {
        if (this.returnedFromNext != null) {
            this.returnedFromNext.setInvalid();
            this.returnedFromNext.setParent(null);
            this.owner.resetCachedFromAndTo();
        }
        this.returnedFromNext = null;
        this.base.remove();
    }

    @Override
    public void set(SpanNode spanNode) {
        if (this.returnedFromNext != null) {
            this.returnedFromNext.setInvalid();
            this.returnedFromNext.setParent(null);
        }
        this.owner.resetCachedFromAndTo();
        this.returnedFromNext = null;
        this.base.set(spanNode);
    }

    @Override
    public void add(SpanNode spanNode) {
        this.returnedFromNext = null;
        this.owner.resetCachedFromAndTo();
        this.base.add(spanNode);
    }
}

