/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;

public class FieldPathEntry {
    private final Type type;
    private final int lookupIndex;
    private final FieldValue lookupKey;
    private final String variableName;
    private final Field fieldRef;
    private final DataType resultingDataType;

    public DataType getResultingDataType() {
        return this.resultingDataType;
    }

    public Type getType() {
        return this.type;
    }

    public Field getFieldRef() {
        return this.fieldRef;
    }

    public int getLookupIndex() {
        return this.lookupIndex;
    }

    public FieldValue getLookupKey() {
        return this.lookupKey;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        String retVal = this.type.toString() + ": ";
        switch (this.type) {
            case STRUCT_FIELD: {
                retVal = retVal + this.getFieldRef();
                break;
            }
            case ARRAY_INDEX: {
                retVal = retVal + this.getLookupIndex();
                break;
            }
            case MAP_KEY: {
                retVal = retVal + this.getLookupKey();
                break;
            }
            case MAP_ALL_KEYS: 
            case MAP_ALL_VALUES: {
                break;
            }
            case VARIABLE: {
                retVal = retVal + this.getVariableName();
            }
        }
        return retVal;
    }

    public static FieldPathEntry newStructFieldEntry(Field fieldRef) {
        return new FieldPathEntry(fieldRef);
    }

    public static FieldPathEntry newArrayLookupEntry(int lookupIndex, DataType resultingDataType) {
        return new FieldPathEntry(lookupIndex, resultingDataType);
    }

    public static FieldPathEntry newMapLookupEntry(FieldValue lookupKey, DataType resultingDataType) {
        return new FieldPathEntry(lookupKey, resultingDataType);
    }

    public static FieldPathEntry newAllKeysLookupEntry(DataType resultingDataType) {
        return new FieldPathEntry(true, false, resultingDataType);
    }

    public static FieldPathEntry newAllValuesLookupEntry(DataType resultingDataType) {
        return new FieldPathEntry(false, true, resultingDataType);
    }

    public static FieldPathEntry newVariableLookupEntry(String variableName, DataType resultingDataType) {
        return new FieldPathEntry(variableName, resultingDataType);
    }

    private FieldPathEntry(Field fieldRef) {
        this.type = Type.STRUCT_FIELD;
        this.lookupIndex = 0;
        this.lookupKey = null;
        this.variableName = null;
        this.fieldRef = fieldRef;
        this.resultingDataType = fieldRef.getDataType();
    }

    private FieldPathEntry(int lookupIndex, DataType resultingDataType) {
        this.type = Type.ARRAY_INDEX;
        this.lookupIndex = lookupIndex;
        this.lookupKey = null;
        this.variableName = null;
        this.fieldRef = null;
        this.resultingDataType = resultingDataType;
    }

    private FieldPathEntry(FieldValue lookupKey, DataType resultingDataType) {
        this.type = Type.MAP_KEY;
        this.lookupIndex = 0;
        this.lookupKey = lookupKey;
        this.variableName = null;
        this.fieldRef = null;
        this.resultingDataType = resultingDataType;
    }

    private FieldPathEntry(boolean keysOnly, boolean valuesOnly, DataType resultingDataType) {
        this.type = keysOnly ? Type.MAP_ALL_KEYS : Type.MAP_ALL_VALUES;
        this.lookupIndex = 0;
        this.lookupKey = null;
        this.variableName = null;
        this.fieldRef = null;
        this.resultingDataType = resultingDataType;
    }

    private FieldPathEntry(String variableName, DataType resultingDataType) {
        this.type = Type.VARIABLE;
        this.lookupIndex = 0;
        this.lookupKey = null;
        this.variableName = variableName;
        this.fieldRef = null;
        this.resultingDataType = resultingDataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPathEntry that = (FieldPathEntry)o;
        if (this.lookupIndex != that.lookupIndex) {
            return false;
        }
        if (this.fieldRef != null ? !this.fieldRef.equals(that.fieldRef) : that.fieldRef != null) {
            return false;
        }
        if (this.lookupKey != null ? !this.lookupKey.equals(that.lookupKey) : that.lookupKey != null) {
            return false;
        }
        if (this.resultingDataType != null ? !this.resultingDataType.equals(that.resultingDataType) : that.resultingDataType != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.variableName != null ? !this.variableName.equals(that.variableName) : that.variableName != null);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.lookupIndex;
        result = 31 * result + (this.lookupKey != null ? this.lookupKey.hashCode() : 0);
        result = 31 * result + (this.variableName != null ? this.variableName.hashCode() : 0);
        result = 31 * result + (this.fieldRef != null ? this.fieldRef.hashCode() : 0);
        result = 31 * result + (this.resultingDataType != null ? this.resultingDataType.hashCode() : 0);
        return result;
    }

    private static int parseQuotedString(String key, int offset, int len, StringBuilder builder) {
        while (offset < len && key.charAt(offset) != '\"') {
            if (key.charAt(offset) == '\\' && (++offset == len || key.charAt(offset) != '\"')) {
                throw new IllegalArgumentException("Escaped key '" + key + "' has bad quote character escape sequence. Expected '\"'");
            }
            if (offset < len) {
                builder.append(key.charAt(offset));
            }
            ++offset;
        }
        if (offset < len && key.charAt(offset) == '\"') {
            return offset + 1;
        }
        throw new IllegalArgumentException("Escaped key '" + key + "' is incomplete. No matching '\"'");
    }

    private static int skipWhitespace(String str, int offset, int len) {
        while (offset < len && Character.isSpaceChar(str.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    public static KeyParseResult parseKey(String key) {
        StringBuilder parsed = new StringBuilder(key.length());
        int i = 0;
        int len = key.length();
        if (i < len && key.charAt(0) == '{') {
            if ((i = FieldPathEntry.skipWhitespace(key, i + 1, len)) < len && key.charAt(i) == '\"') {
                i = FieldPathEntry.parseQuotedString(key, i + 1, len, parsed);
            } else {
                while (i < len && key.charAt(i) != '}') {
                    parsed.append(key.charAt(i));
                    ++i;
                }
            }
            i = FieldPathEntry.skipWhitespace(key, i, len);
            if (i < len && key.charAt(i) == '}') {
                return new KeyParseResult(parsed.toString(), i + 1);
            }
            throw new IllegalArgumentException("Key '" + key + "' is incomplete. No matching '}'");
        }
        throw new IllegalArgumentException("Key '" + key + "' does not start with '{'");
    }

    public static enum Type {
        STRUCT_FIELD,
        ARRAY_INDEX,
        MAP_KEY,
        MAP_ALL_KEYS,
        MAP_ALL_VALUES,
        VARIABLE;

    }

    public static class KeyParseResult {
        public String parsed;
        public int consumedChars;

        public KeyParseResult(String parsed, int consumedChars) {
            this.parsed = parsed;
            this.consumedChars = consumedChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyParseResult that = (KeyParseResult)o;
            if (this.consumedChars != that.consumedChars) {
                return false;
            }
            return this.parsed.equals(that.parsed);
        }

        public int hashCode() {
            int result = this.parsed.hashCode();
            result = 31 * result + this.consumedChars;
            return result;
        }

        public String toString() {
            return "KeyParseResult(parsed=\"" + this.parsed + "\", consumedChars=" + this.consumedChars + ")";
        }
    }
}

