/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.text.XML;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;

public class XmlStream {
    private final StringWriter writer;
    private final Deque<String> tags = new ArrayDeque<String>();
    private String indent = "";
    private String cachedTag = null;
    private final List<Attribute> cachedAttribute = new ArrayList<Attribute>();
    private final List<String> cachedContent = new ArrayList<String>();

    public XmlStream() {
        this.writer = new StringWriter();
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public boolean isFinalized() {
        return this.tags.isEmpty() && this.cachedTag == null;
    }

    public String toString() {
        if (!this.isFinalized()) {
            throw new IllegalStateException("There are still tag(s) that are not closed.");
        }
        StringWriter sw = this.writer;
        return sw.toString();
    }

    public void beginTag(String name) {
        if (!XML.isName((CharSequence)name)) {
            throw new IllegalArgumentException("The name '" + name + "' cannot be used as an XML tag name. Legal names must adhere tohttp://www.w3.org/TR/2006/REC-xml11-20060816/#sec-common-syn");
        }
        if (this.cachedTag != null) {
            this.flush(false);
        }
        this.cachedTag = name;
    }

    public void addAttribute(String key, Object value) {
        if (value == null) {
            return;
        }
        if (this.cachedTag == null) {
            throw new IllegalStateException("There is no open tag to add attributes to.");
        }
        if (!XML.isName((CharSequence)key)) {
            throw new IllegalArgumentException("The name '" + key + "' cannot be used as an XML attribute name. Legal names must adhere to http://www.w3.org/TR/2006/REC-xml11-20060816/#sec-common-syn");
        }
        this.cachedAttribute.add(new Attribute(key, value));
    }

    public void addContent(String content) {
        if (this.cachedTag != null) {
            this.cachedContent.add(XML.xmlEscape((String)content, (boolean)false));
        } else {
            if (this.tags.isEmpty()) {
                throw new IllegalStateException("There is no open tag to add content to.");
            }
            for (int i = 0; i < this.tags.size(); ++i) {
                this.writer.write(this.indent);
            }
            this.writer.write(XML.xmlEscape((String)content, (boolean)false));
            this.writer.write(10);
        }
    }

    public void endTag() {
        if (this.cachedTag != null) {
            this.flush(true);
        } else {
            if (this.tags.isEmpty()) {
                throw new IllegalStateException("Cannot end non-existing tag");
            }
            for (int i = 1; i < this.tags.size(); ++i) {
                this.writer.write(this.indent);
            }
            this.writer.write("</");
            this.writer.write(this.tags.removeFirst());
            this.writer.write(">\n");
        }
    }

    private void flush(boolean endTag) {
        if (this.cachedTag == null) {
            throw new IllegalStateException("Cannot write non-existing tag");
        }
        for (int i = 0; i < this.tags.size(); ++i) {
            this.writer.write(this.indent);
        }
        this.writer.write(60);
        this.writer.write(this.cachedTag);
        ListIterator<Attribute> it = this.cachedAttribute.listIterator();
        while (it.hasNext()) {
            Attribute attr = it.next();
            this.writer.write(32);
            this.writer.write(attr.name);
            this.writer.write("=\"");
            this.writer.write(XML.xmlEscape((String)attr.value, (boolean)true));
            this.writer.write(34);
        }
        this.cachedAttribute.clear();
        if (this.cachedContent.isEmpty() && endTag) {
            this.writer.write("/>\n");
        } else if (this.cachedContent.isEmpty()) {
            this.writer.write(">\n");
            this.tags.addFirst(this.cachedTag);
        } else {
            this.writer.write(">");
            if (!endTag) {
                this.writer.write(10);
                for (int i = 0; i <= this.tags.size(); ++i) {
                    this.writer.write(this.indent);
                }
            }
            for (String content : this.cachedContent) {
                this.writer.write(content);
            }
            this.cachedContent.clear();
            if (endTag) {
                this.writer.write("</");
                this.writer.write(this.cachedTag);
                this.writer.write(">\n");
            } else {
                this.writer.write(10);
                this.tags.addFirst(this.cachedTag);
            }
        }
        this.cachedTag = null;
    }

    private static class Attribute {
        final String name;
        final String value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value.toString();
        }
    }
}

