/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.idstring;

import com.yahoo.collections.MD5;
import com.yahoo.document.idstring.IdString;
import com.yahoo.text.Utf8;
import java.security.MessageDigest;

public class OrderDocIdString
extends IdString {
    String group;
    int widthBits;
    int divisionBits;
    long ordering;
    long location;

    public OrderDocIdString(String namespace, String group, int widthBits, int divisionBits, long ordering, String namespaceSpecific) {
        super(IdString.Scheme.orderdoc, namespace, namespaceSpecific);
        this.group = group;
        this.widthBits = widthBits;
        this.divisionBits = divisionBits;
        this.ordering = ordering;
        try {
            this.location = Long.parseLong(group);
        }
        catch (Exception foo) {
            this.location = 0L;
            byte[] md5sum = ((MessageDigest)MD5.md5.get()).digest(Utf8.toBytes((String)group));
            for (int i = 0; i < 8; ++i) {
                this.location |= ((long)md5sum[i] & 0xFFL) << 8 * i;
            }
        }
    }

    @Override
    public long getLocation() {
        return this.location;
    }

    @Override
    public String getSchemeParameters() {
        return "(" + this.widthBits + "," + this.divisionBits + ")";
    }

    @Override
    public String getSchemeSpecific() {
        return this.group + ":" + this.ordering + ":";
    }

    @Override
    public IdString.GidModifier getGidModifier() {
        IdString.GidModifier gm = new IdString.GidModifier();
        gm.usedBits = this.widthBits - this.divisionBits;
        long gidBits = this.ordering << 64 - this.widthBits;
        gidBits = Long.reverse(gidBits);
        long gidMask = -1L >>> 64 - gm.usedBits;
        gm.value = gidBits &= gidMask;
        return gm;
    }

    @Override
    public boolean hasGroup() {
        return true;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean hasNumber() {
        return true;
    }

    @Override
    public long getNumber() {
        return this.location;
    }

    public long getUserId() {
        return this.location;
    }

    public int getWidthBits() {
        return this.widthBits;
    }

    public int getDivisionBits() {
        return this.divisionBits;
    }

    public long getOrdering() {
        return this.ordering;
    }
}

