/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.IteratingAnnotationContainer;
import com.yahoo.document.annotation.PeekableListIterator;
import com.yahoo.document.annotation.SpanNode;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListAnnotationContainer
extends IteratingAnnotationContainer {
    private final List<Annotation> annotations = new LinkedList<Annotation>();

    @Override
    void annotateAll(Collection<Annotation> annotations) {
        this.annotations.addAll(annotations);
    }

    @Override
    void annotate(Annotation a) {
        this.annotations.add(a);
    }

    @Override
    Collection<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    Iterator<Annotation> iterator(IdentityHashMap<SpanNode, SpanNode> nodes) {
        return new AnnotationIterator(this.annotations.listIterator(), nodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAnnotationContainer)) {
            return false;
        }
        ListAnnotationContainer that = (ListAnnotationContainer)o;
        return this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    private class AnnotationIterator
    implements Iterator<Annotation> {
        private IdentityHashMap<SpanNode, SpanNode> nodes;
        private PeekableListIterator<Annotation> base;
        private boolean nextCalled = false;

        AnnotationIterator(ListIterator<Annotation> baseIt, IdentityHashMap<SpanNode, SpanNode> nodes) {
            this.base = new PeekableListIterator<Annotation>(baseIt);
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            this.nextCalled = false;
            while (this.base.hasNext() && !this.nodes.containsKey(this.base.peek().getSpanNode())) {
                this.base.next();
            }
            return this.base.hasNext();
        }

        @Override
        public Annotation next() {
            if (this.hasNext()) {
                this.nextCalled = true;
                return this.base.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.nextCalled) {
                throw new IllegalStateException();
            }
            this.base.remove();
            this.nextCalled = false;
        }
    }
}

