/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.VespaDocumentDeserializer6;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;

public class VespaDocumentDeserializerHead
extends VespaDocumentDeserializer6 {
    public VespaDocumentDeserializerHead(DocumentTypeManager manager, GrowableByteBuffer buffer) {
        super(manager, buffer);
    }

    @Override
    protected ValueUpdate readTensorModifyUpdate(DataType type) {
        byte operationId = this.getByte(null);
        TensorModifyUpdate.Operation operation = TensorModifyUpdate.Operation.getOperation(operationId);
        if (operation == null) {
            throw new DeserializationException("Unknown operation id " + operationId + " for tensor modify update");
        }
        FieldValue fieldValue = type.createFieldValue();
        if (!(fieldValue instanceof TensorFieldValue)) {
            throw new DeserializationException("Expected tensor field value, got " + type);
        }
        TensorFieldValue tensor = (TensorFieldValue)fieldValue;
        tensor.deserialize(this);
        return new TensorModifyUpdate(operation, tensor);
    }
}

