/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.TensorReader;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorModifyUpdateReader {
    public static final String UPDATE_MODIFY = "modify";
    private static final String MODIFY_OPERATION = "operation";
    private static final String MODIFY_REPLACE = "replace";
    private static final String MODIFY_ADD = "add";
    private static final String MODIFY_MULTIPLY = "multiply";

    public static TensorModifyUpdate createModifyUpdate(TokenBuffer buffer, Field field) {
        TensorModifyUpdateReader.expectFieldIsOfTypeTensor(field);
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        ModifyUpdateResult result = TensorModifyUpdateReader.createModifyUpdateResult(buffer, field);
        TensorModifyUpdateReader.expectOperationSpecified(result.operation, field.getName());
        TensorModifyUpdateReader.expectTensorSpecified(result.tensor, field.getName());
        return new TensorModifyUpdate(result.operation, result.tensor);
    }

    private static void expectFieldIsOfTypeTensor(Field field) {
        if (!(field.getDataType() instanceof TensorDataType)) {
            throw new IllegalArgumentException("A modify update can only be applied to tensor fields. Field '" + field.getName() + "' is of type '" + field.getDataType().getName() + "'");
        }
    }

    private static void expectOperationSpecified(TensorModifyUpdate.Operation operation, String fieldName) {
        if (operation == null) {
            throw new IllegalArgumentException("Modify update for field '" + fieldName + "' does not contain an operation");
        }
    }

    private static void expectTensorSpecified(TensorFieldValue tensor, String fieldName) {
        if (tensor == null) {
            throw new IllegalArgumentException("Modify update for field '" + fieldName + "' does not contain tensor cells");
        }
    }

    private static ModifyUpdateResult createModifyUpdateResult(TokenBuffer buffer, Field field) {
        ModifyUpdateResult result = new ModifyUpdateResult();
        TensorDataType tensorDataType = (TensorDataType)field.getDataType();
        buffer.next();
        int localNesting = buffer.nesting();
        while (localNesting <= buffer.nesting()) {
            switch (buffer.currentName()) {
                case "operation": {
                    result.operation = TensorModifyUpdateReader.createOperation(buffer, field.getName());
                    break;
                }
                case "cells": {
                    result.tensor = TensorModifyUpdateReader.createTensor(buffer, tensorDataType.getTensorType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JSON string '" + buffer.currentName() + "' in modify update for field '" + field.getName() + "'");
                }
            }
            buffer.next();
        }
        return result;
    }

    private static TensorModifyUpdate.Operation createOperation(TokenBuffer buffer, String fieldName) {
        switch (buffer.currentText()) {
            case "replace": {
                return TensorModifyUpdate.Operation.REPLACE;
            }
            case "add": {
                return TensorModifyUpdate.Operation.ADD;
            }
            case "multiply": {
                return TensorModifyUpdate.Operation.MULTIPLY;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + buffer.currentText() + "' in modify update for field '" + fieldName + "'");
    }

    private static TensorFieldValue createTensor(TokenBuffer buffer, TensorType tensorType) {
        Tensor.Builder tensorBuilder = Tensor.Builder.of((TensorType)tensorType);
        TensorReader.readTensorCells(buffer, tensorBuilder);
        TensorFieldValue result = new TensorFieldValue(tensorType);
        result.assign(tensorBuilder.build());
        return result;
    }

    private static class ModifyUpdateResult {
        TensorModifyUpdate.Operation operation = null;
        TensorFieldValue tensor = null;

        private ModifyUpdateResult() {
        }
    }
}

