/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;

public class TensorReader {
    public static final String TENSOR_ADDRESS = "address";
    public static final String TENSOR_DIMENSIONS = "dimensions";
    public static final String TENSOR_CELLS = "cells";
    public static final String TENSOR_VALUES = "values";
    public static final String TENSOR_BLOCKS = "blocks";
    public static final String TENSOR_VALUE = "value";

    static void fillTensor(TokenBuffer buffer, TensorFieldValue tensorFieldValue) {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)tensorFieldValue.getDataType().getTensorType());
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_CELLS.equals(buffer.currentName())) {
                TensorReader.readTensorCells(buffer, builder);
            } else if (TENSOR_VALUES.equals(buffer.currentName())) {
                TensorReader.readTensorValues(buffer, builder);
            } else if (TENSOR_BLOCKS.equals(buffer.currentName())) {
                TensorReader.readTensorBlocks(buffer, builder);
            } else if (builder.type().dimensions().stream().anyMatch(d -> d.isIndexed())) {
                throw new IllegalArgumentException("Expected a tensor value to contain either 'cells', 'values' or 'blocks', but got: " + buffer.currentName());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        tensorFieldValue.assign(builder.build());
    }

    static void readTensorCells(TokenBuffer buffer, Tensor.Builder builder) {
        if (buffer.currentToken() == JsonToken.START_ARRAY) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorReader.readTensorCell(buffer, builder);
                buffer.next();
            }
        } else if (buffer.currentToken() == JsonToken.START_OBJECT) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                builder.cell(TensorReader.asAddress(buffer.currentName(), builder.type()), TensorReader.readDouble(buffer));
                buffer.next();
            }
        } else {
            throw new IllegalArgumentException("Expected 'cells' to contain an array or an object, but got " + buffer.currentToken());
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    private static void readTensorCell(TokenBuffer buffer, Tensor.Builder builder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorAddress address = null;
        Double value = null;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                address = TensorReader.readAddress(buffer, builder.type());
            } else if (TENSOR_VALUE.equals(currentName)) {
                value = TensorReader.readDouble(buffer);
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        if (address == null) {
            throw new IllegalArgumentException("Expected an object in a tensor 'cells' array to contain an 'address' field");
        }
        if (value == null) {
            throw new IllegalArgumentException("Expected an object in a tensor 'cells' array to contain a 'value' field");
        }
        builder.cell(address, value.doubleValue());
    }

    private static void readTensorValues(TokenBuffer buffer, Tensor.Builder builder) {
        if (!(builder instanceof IndexedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("The 'values' field can only be used with dense tensors. Use 'cells' or 'blocks' instead");
        }
        IndexedTensor.BoundBuilder indexedBuilder = (IndexedTensor.BoundBuilder)builder;
        if (buffer.currentToken() == JsonToken.VALUE_STRING) {
            double[] decoded = JsonFormat.decodeHexString((String)buffer.currentText(), (TensorType.Value)builder.type().valueType());
            for (int i = 0; i < decoded.length; ++i) {
                indexedBuilder.cellByDirectIndex((long)i, decoded[i]);
            }
            return;
        }
        int index = 0;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            indexedBuilder.cellByDirectIndex((long)index++, TensorReader.readDouble(buffer));
            buffer.next();
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    static void readTensorBlocks(TokenBuffer buffer, Tensor.Builder builder) {
        if (!(builder instanceof MixedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("The 'blocks' field can only be used with mixed tensors with bound dimensions. Use 'cells' or 'values' instead");
        }
        MixedTensor.BoundBuilder mixedBuilder = (MixedTensor.BoundBuilder)builder;
        if (buffer.currentToken() == JsonToken.START_ARRAY) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorReader.readTensorBlock(buffer, mixedBuilder);
                buffer.next();
            }
        } else if (buffer.currentToken() == JsonToken.START_OBJECT) {
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                TensorAddress mappedAddress = TensorReader.asAddress(buffer.currentName(), builder.type().mappedSubtype());
                mixedBuilder.block(mappedAddress, TensorReader.readValues(buffer, (int)mixedBuilder.denseSubspaceSize(), mappedAddress, mixedBuilder.type()));
                buffer.next();
            }
        } else {
            throw new IllegalArgumentException("Expected 'blocks' to contain an array or an object, but got " + buffer.currentToken());
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    private static void readTensorBlock(TokenBuffer buffer, MixedTensor.BoundBuilder mixedBuilder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorAddress address = null;
        double[] values = null;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                address = TensorReader.readAddress(buffer, mixedBuilder.type().mappedSubtype());
            } else if (TENSOR_VALUES.equals(currentName)) {
                values = TensorReader.readValues(buffer, (int)mixedBuilder.denseSubspaceSize(), address, mixedBuilder.type());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        if (address == null) {
            throw new IllegalArgumentException("Expected a 'blocks' array object to contain an object 'address'");
        }
        if (values == null) {
            throw new IllegalArgumentException("Expected a 'blocks' array object to contain an array 'values'");
        }
        mixedBuilder.block(address, values);
    }

    private static TensorAddress readAddress(TokenBuffer buffer, TensorType type) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            builder.add(buffer.currentName(), buffer.currentText());
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        return builder.build();
    }

    private static double[] readValues(TokenBuffer buffer, int size, TensorAddress address, TensorType type) {
        int index = 0;
        double[] values = new double[size];
        if (buffer.currentToken() == JsonToken.VALUE_STRING) {
            values = JsonFormat.decodeHexString((String)buffer.currentText(), (TensorType.Value)type.valueType());
            index = values.length;
        } else {
            JsonParserHelpers.expectArrayStart(buffer.currentToken());
            int initNesting = buffer.nesting();
            buffer.next();
            while (buffer.nesting() >= initNesting) {
                values[index++] = TensorReader.readDouble(buffer);
                buffer.next();
            }
            JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
        }
        if (index != size) {
            throw new IllegalArgumentException((String)(address != null ? "At " + address.toString(type) + ": " : "") + "Expected " + size + " values, but got " + index);
        }
        return values;
    }

    private static double readDouble(TokenBuffer buffer) {
        try {
            return Double.parseDouble(buffer.currentText());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a number but got '" + buffer.currentText());
        }
    }

    private static TensorAddress asAddress(String label, TensorType type) {
        if (type.dimensions().size() != 1) {
            throw new IllegalArgumentException("Expected a tensor with a single dimension but got " + type);
        }
        return new TensorAddress.Builder(type).add(((TensorType.Dimension)type.dimensions().get(0)).name(), label).build();
    }
}

