/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.BucketId;
import com.yahoo.document.DocumentId;

public class BucketIdFactory {
    private final int gidBits;
    private final int locationBits;
    private final int countBits;
    private final long initialCount;
    private final long locationMask;
    private final long gidMask;

    public BucketIdFactory() {
        this(32, 26, 6);
    }

    public BucketIdFactory(int locationBits, int gidBits, int countBits) {
        this.locationBits = locationBits;
        this.gidBits = gidBits;
        this.countBits = countBits;
        this.initialCount = 58L << 64 - countBits;
        this.locationMask = -1L >>> 64 - this.getLocationBitCount();
        this.gidMask = -1L >>> this.getLocationBitCount() << this.getLocationBitCount() + 6 >>> 6;
    }

    public BucketIdFactory(String configId) {
        this(32, 26, 6);
    }

    public int getLocationBitCount() {
        return this.locationBits;
    }

    public int getGidBitCount() {
        return this.gidBits;
    }

    public int getCountBitCount() {
        return this.countBits;
    }

    private long getGidContribution(byte[] gid) {
        long gidbits = 0L;
        for (int i = 4; i < 12; ++i) {
            gidbits <<= 8;
            long tall = (long)gid[15 - i] & 0xFFL;
            assert (tall >= 0L && tall <= 255L);
            gidbits |= tall;
        }
        return gidbits & this.gidMask;
    }

    public BucketId getBucketId(DocumentId doc) {
        long location = doc.getScheme().getLocation();
        byte[] gid = doc.getGlobalId();
        long gidContribution = this.getGidContribution(gid);
        return new BucketId(58, this.initialCount | this.gidMask & gidContribution | this.locationMask & location);
    }
}

