/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.json.DocumentOperationType;
import com.yahoo.document.json.JsonReader;
import com.yahoo.vespaxmlparser.DocumentFeedOperation;
import com.yahoo.vespaxmlparser.DocumentUpdateFeedOperation;
import com.yahoo.vespaxmlparser.FeedOperation;
import java.io.IOException;
import java.io.InputStream;

public class SingleDocumentParser {
    private static final JsonFactory jsonFactory = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private DocumentTypeManager docMan;

    public SingleDocumentParser(DocumentTypeManager docMan) {
        this.docMan = docMan;
    }

    public FeedOperation parsePut(InputStream inputStream, String docId) {
        return this.parse(inputStream, docId, DocumentOperationType.PUT);
    }

    public FeedOperation parseUpdate(InputStream inputStream, String docId) {
        return this.parse(inputStream, docId, DocumentOperationType.UPDATE);
    }

    private FeedOperation parse(InputStream inputStream, String docId, DocumentOperationType documentOperationType) {
        JsonReader reader = new JsonReader(this.docMan, inputStream, jsonFactory);
        DocumentOperation documentOperation = reader.readSingleDocument(documentOperationType, docId);
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (documentOperationType == DocumentOperationType.PUT) {
            return new DocumentFeedOperation(((DocumentPut)documentOperation).getDocument(), documentOperation.getCondition());
        }
        return new DocumentUpdateFeedOperation((DocumentUpdate)documentOperation, documentOperation.getCondition());
    }
}

