/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.net.Url;
import java.net.URI;

public class UriFieldValue
extends StringFieldValue {
    public UriFieldValue() {
    }

    public UriFieldValue(String value) {
        super(value);
        Url.fromString((String)value);
    }

    @Override
    public void assign(Object obj) {
        if (obj instanceof URI) {
            obj = obj.toString();
        }
        super.assign(obj);
    }

    @Override
    public DataType getDataType() {
        return DataType.URI;
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        super.deserialize(field, reader);
        Url.fromString((String)this.toString());
    }

    public static class Factory
    extends PrimitiveDataType.Factory {
        @Override
        public FieldValue create() {
            return new UriFieldValue();
        }
    }
}

