/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DocumentmanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "717fad5b9c9b6bfdbc6cefb8351a2da3";
    public static final String CONFIG_DEF_NAME = "documentmanager";
    public static final String CONFIG_DEF_NAMESPACE = "document.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=document.config", "enablecompression bool default=false", "datatype[].id int", "datatype[].arraytype[].datatype int", "datatype[].maptype[].keytype int", "datatype[].maptype[].valtype int", "datatype[].weightedsettype[].datatype int", "datatype[].weightedsettype[].createifnonexistant bool default=false", "datatype[].weightedsettype[].removeifzero bool default=false", "datatype[].structtype[].name string", "datatype[].structtype[].version int default=0", "datatype[].structtype[].compresstype enum { NONE, UNCOMPRESSABLE, LZ4 } default=NONE", "datatype[].structtype[].compresslevel int default=0", "datatype[].structtype[].compressthreshold int default=95", "datatype[].structtype[].compressminsize int default=800", "datatype[].structtype[].field[].name string", "datatype[].structtype[].field[].id[].id int", "datatype[].structtype[].field[].datatype int", "datatype[].structtype[].field[].detailedtype string default=\"\"", "datatype[].structtype[].inherits[].name string", "datatype[].structtype[].inherits[].version int default=0", "datatype[].annotationreftype[].annotation string", "datatype[].documenttype[].name string", "datatype[].documenttype[].version int default=0", "datatype[].documenttype[].inherits[].name string", "datatype[].documenttype[].inherits[].version int default=0", "datatype[].documenttype[].headerstruct int", "datatype[].documenttype[].bodystruct int default=0", "datatype[].documenttype[].fieldsets{}.fields[] string", "datatype[].documenttype[].importedfield[].name string", "datatype[].referencetype[].target_type_id int", "annotationtype[].id int", "annotationtype[].name string", "annotationtype[].datatype int default=-1", "annotationtype[].inherits[].id int"};
    private final BooleanNode enablecompression;
    private final InnerNodeVector<Datatype> datatype;
    private final InnerNodeVector<Annotationtype> annotationtype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public DocumentmanagerConfig(Builder builder) {
        this(builder, true);
    }

    private DocumentmanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for documentmanager must be initialized: " + builder.__uninitialized);
        }
        this.enablecompression = builder.enablecompression == null ? new BooleanNode(false) : new BooleanNode(builder.enablecompression.booleanValue());
        this.datatype = Datatype.createVector(builder.datatype);
        this.annotationtype = Annotationtype.createVector(builder.annotationtype);
    }

    public boolean enablecompression() {
        return this.enablecompression.value();
    }

    public List<Datatype> datatype() {
        return this.datatype;
    }

    public Datatype datatype(int i) {
        return (Datatype)((Object)this.datatype.get(i));
    }

    public List<Annotationtype> annotationtype() {
        return this.annotationtype;
    }

    public Annotationtype annotationtype(int i) {
        return (Annotationtype)((Object)this.annotationtype.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DocumentmanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Annotationtype
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final IntegerNode datatype;
        private final InnerNodeVector<Inherits> inherits;

        public Annotationtype(Builder builder) {
            this(builder, true);
        }

        private Annotationtype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documentmanager.annotationtype[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.datatype = builder.datatype == null ? new IntegerNode(-1) : new IntegerNode(builder.datatype.intValue());
            this.inherits = Inherits.createVector(builder.inherits);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public int datatype() {
            return this.datatype.value();
        }

        public List<Inherits> inherits() {
            return this.inherits;
        }

        public Inherits inherits(int i) {
            return (Inherits)((Object)this.inherits.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
            return changes;
        }

        private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
            ArrayList<Annotationtype> elems = new ArrayList<Annotationtype>();
            for (Builder b : builders) {
                elems.add(new Annotationtype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Inherits
        extends InnerNode {
            private final IntegerNode id;

            public Inherits(Builder builder) {
                this(builder, true);
            }

            private Inherits(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            }

            public int id() {
                return this.id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                return changes;
            }

            private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                ArrayList<Inherits> elems = new ArrayList<Inherits>();
                for (Builder b : builders) {
                    elems.add(new Inherits(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
                private Integer id = null;

                public Builder() {
                }

                public Builder(Inherits config) {
                    this.id(config.id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }

                public Inherits build() {
                    return new Inherits(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "name"));
            private Integer id = null;
            private String name = null;
            private Integer datatype = null;
            public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

            public Builder() {
            }

            public Builder(Annotationtype config) {
                this.id(config.id());
                this.name(config.name());
                this.datatype(config.datatype());
                for (Inherits i : config.inherits()) {
                    this.inherits(new Inherits.Builder(i));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (!__superior.inherits.isEmpty()) {
                    this.inherits.addAll(__superior.inherits);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder datatype(int __value) {
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Integer.valueOf(__value));
            }

            public Builder inherits(Inherits.Builder __builder) {
                this.inherits.add(__builder);
                return this;
            }

            public Builder inherits(List<Inherits.Builder> __builders) {
                this.inherits = __builders;
                return this;
            }

            public Annotationtype build() {
                return new Annotationtype(this);
            }
        }
    }

    public static final class Datatype
    extends InnerNode {
        private final IntegerNode id;
        private final InnerNodeVector<Arraytype> arraytype;
        private final InnerNodeVector<Maptype> maptype;
        private final InnerNodeVector<Weightedsettype> weightedsettype;
        private final InnerNodeVector<Structtype> structtype;
        private final InnerNodeVector<Annotationreftype> annotationreftype;
        private final InnerNodeVector<Documenttype> documenttype;
        private final InnerNodeVector<Referencetype> referencetype;

        public Datatype(Builder builder) {
            this(builder, true);
        }

        private Datatype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.arraytype = Arraytype.createVector(builder.arraytype);
            this.maptype = Maptype.createVector(builder.maptype);
            this.weightedsettype = Weightedsettype.createVector(builder.weightedsettype);
            this.structtype = Structtype.createVector(builder.structtype);
            this.annotationreftype = Annotationreftype.createVector(builder.annotationreftype);
            this.documenttype = Documenttype.createVector(builder.documenttype);
            this.referencetype = Referencetype.createVector(builder.referencetype);
        }

        public int id() {
            return this.id.value();
        }

        public List<Arraytype> arraytype() {
            return this.arraytype;
        }

        public Arraytype arraytype(int i) {
            return (Arraytype)((Object)this.arraytype.get(i));
        }

        public List<Maptype> maptype() {
            return this.maptype;
        }

        public Maptype maptype(int i) {
            return (Maptype)((Object)this.maptype.get(i));
        }

        public List<Weightedsettype> weightedsettype() {
            return this.weightedsettype;
        }

        public Weightedsettype weightedsettype(int i) {
            return (Weightedsettype)((Object)this.weightedsettype.get(i));
        }

        public List<Structtype> structtype() {
            return this.structtype;
        }

        public Structtype structtype(int i) {
            return (Structtype)((Object)this.structtype.get(i));
        }

        public List<Annotationreftype> annotationreftype() {
            return this.annotationreftype;
        }

        public Annotationreftype annotationreftype(int i) {
            return (Annotationreftype)((Object)this.annotationreftype.get(i));
        }

        public List<Documenttype> documenttype() {
            return this.documenttype;
        }

        public Documenttype documenttype(int i) {
            return (Documenttype)((Object)this.documenttype.get(i));
        }

        public List<Referencetype> referencetype() {
            return this.referencetype;
        }

        public Referencetype referencetype(int i) {
            return (Referencetype)((Object)this.referencetype.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Datatype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("datatype");
            return changes;
        }

        private static InnerNodeVector<Datatype> createVector(List<Builder> builders) {
            ArrayList<Datatype> elems = new ArrayList<Datatype>();
            for (Builder b : builders) {
                elems.add(new Datatype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Referencetype
        extends InnerNode {
            private final IntegerNode target_type_id;

            public Referencetype(Builder builder) {
                this(builder, true);
            }

            private Referencetype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].referencetype[] must be initialized: " + builder.__uninitialized);
                }
                this.target_type_id = builder.target_type_id == null ? new IntegerNode() : new IntegerNode(builder.target_type_id.intValue());
            }

            public int target_type_id() {
                return this.target_type_id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Referencetype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("referencetype");
                return changes;
            }

            private static InnerNodeVector<Referencetype> createVector(List<Builder> builders) {
                ArrayList<Referencetype> elems = new ArrayList<Referencetype>();
                for (Builder b : builders) {
                    elems.add(new Referencetype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("target_type_id"));
                private Integer target_type_id = null;

                public Builder() {
                }

                public Builder(Referencetype config) {
                    this.target_type_id(config.target_type_id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.target_type_id != null) {
                        this.target_type_id(__superior.target_type_id);
                    }
                    return this;
                }

                public Builder target_type_id(int __value) {
                    this.target_type_id = __value;
                    this.__uninitialized.remove("target_type_id");
                    return this;
                }

                private Builder target_type_id(String __value) {
                    return this.target_type_id(Integer.valueOf(__value));
                }

                public Referencetype build() {
                    return new Referencetype(this);
                }
            }
        }

        public static final class Documenttype
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode version;
            private final InnerNodeVector<Inherits> inherits;
            private final IntegerNode headerstruct;
            private final IntegerNode bodystruct;
            private final Map<String, Fieldsets> fieldsets;
            private final InnerNodeVector<Importedfield> importedfield;

            public Documenttype(Builder builder) {
                this(builder, true);
            }

            private Documenttype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                this.inherits = Inherits.createVector(builder.inherits);
                this.headerstruct = builder.headerstruct == null ? new IntegerNode() : new IntegerNode(builder.headerstruct.intValue());
                this.bodystruct = builder.bodystruct == null ? new IntegerNode(0) : new IntegerNode(builder.bodystruct.intValue());
                this.fieldsets = Fieldsets.createMap(builder.fieldsets);
                this.importedfield = Importedfield.createVector(builder.importedfield);
            }

            public String name() {
                return this.name.value();
            }

            public int version() {
                return this.version.value();
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            public int headerstruct() {
                return this.headerstruct.value();
            }

            public int bodystruct() {
                return this.bodystruct.value();
            }

            public Map<String, Fieldsets> fieldsets() {
                return Collections.unmodifiableMap(this.fieldsets);
            }

            public Fieldsets fieldsets(String key) {
                return this.fieldsets.get(key);
            }

            public List<Importedfield> importedfield() {
                return this.importedfield;
            }

            public Importedfield importedfield(int i) {
                return (Importedfield)((Object)this.importedfield.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
                return changes;
            }

            private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
                ArrayList<Documenttype> elems = new ArrayList<Documenttype>();
                for (Builder b : builders) {
                    elems.add(new Documenttype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Importedfield
            extends InnerNode {
                private final StringNode name;

                public Importedfield(Builder builder) {
                    this(builder, true);
                }

                private Importedfield(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].importedfield[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                }

                public String name() {
                    return this.name.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
                    return changes;
                }

                private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
                    ArrayList<Importedfield> elems = new ArrayList<Importedfield>();
                    for (Builder b : builders) {
                        elems.add(new Importedfield(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                    private String name = null;

                    public Builder() {
                    }

                    public Builder(Importedfield config) {
                        this.name(config.name());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Importedfield build() {
                        return new Importedfield(this);
                    }
                }
            }

            public static final class Fieldsets
            extends InnerNode {
                private final LeafNodeVector<String, StringNode> fields;

                public Fieldsets(Builder builder) {
                    this(builder, true);
                }

                private Fieldsets(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].fieldsets{} must be initialized: " + builder.__uninitialized);
                    }
                    this.fields = new LeafNodeVector(builder.fields, (LeafNode)new StringNode());
                }

                public List<String> fields() {
                    return this.fields.asList();
                }

                public String fields(int i) {
                    return ((StringNode)this.fields.get(i)).value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
                    return changes;
                }

                private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
                    LinkedHashMap<String, Fieldsets> ret = new LinkedHashMap<String, Fieldsets>();
                    for (String key : builders.keySet()) {
                        ret.put(key, new Fieldsets(builders.get(key)));
                    }
                    return Collections.unmodifiableMap(ret);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public List<String> fields = new ArrayList<String>();

                    public Builder() {
                    }

                    public Builder(Fieldsets config) {
                        this.fields(config.fields());
                    }

                    private Builder override(Builder __superior) {
                        if (!__superior.fields.isEmpty()) {
                            this.fields.addAll(__superior.fields);
                        }
                        return this;
                    }

                    public Builder fields(String __value) {
                        this.fields.add(__value);
                        return this;
                    }

                    public Builder fields(Collection<String> __values) {
                        this.fields.addAll(__values);
                        return this;
                    }

                    public Fieldsets build() {
                        return new Fieldsets(this);
                    }
                }
            }

            public static final class Inherits
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode version;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].inherits[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                }

                public String name() {
                    return this.name.value();
                }

                public int version() {
                    return this.version.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                    private String name = null;
                    private Integer version = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.name(config.name());
                        this.version(config.version());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.version != null) {
                            this.version(__superior.version);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder version(int __value) {
                        this.version = __value;
                        return this;
                    }

                    private Builder version(String __value) {
                        return this.version(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "headerstruct"));
                private String name = null;
                private Integer version = null;
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();
                private Integer headerstruct = null;
                private Integer bodystruct = null;
                public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<String, Fieldsets.Builder>();
                public List<Importedfield.Builder> importedfield = new ArrayList<Importedfield.Builder>();

                public Builder() {
                }

                public Builder(Documenttype config) {
                    this.name(config.name());
                    this.version(config.version());
                    for (Inherits inherits : config.inherits()) {
                        this.inherits(new Inherits.Builder(inherits));
                    }
                    this.headerstruct(config.headerstruct());
                    this.bodystruct(config.bodystruct());
                    for (Map.Entry entry : config.fieldsets().entrySet()) {
                        this.fieldsets((String)entry.getKey(), new Fieldsets.Builder((Fieldsets)((Object)entry.getValue())));
                    }
                    for (Importedfield importedfield : config.importedfield()) {
                        this.importedfield(new Importedfield.Builder(importedfield));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.version != null) {
                        this.version(__superior.version);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    if (__superior.headerstruct != null) {
                        this.headerstruct(__superior.headerstruct);
                    }
                    if (__superior.bodystruct != null) {
                        this.bodystruct(__superior.bodystruct);
                    }
                    this.fieldsets(__superior.fieldsets);
                    if (!__superior.importedfield.isEmpty()) {
                        this.importedfield.addAll(__superior.importedfield);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder version(int __value) {
                    this.version = __value;
                    return this;
                }

                private Builder version(String __value) {
                    return this.version(Integer.valueOf(__value));
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Builder headerstruct(int __value) {
                    this.headerstruct = __value;
                    this.__uninitialized.remove("headerstruct");
                    return this;
                }

                private Builder headerstruct(String __value) {
                    return this.headerstruct(Integer.valueOf(__value));
                }

                public Builder bodystruct(int __value) {
                    this.bodystruct = __value;
                    return this;
                }

                private Builder bodystruct(String __value) {
                    return this.bodystruct(Integer.valueOf(__value));
                }

                public Builder fieldsets(String __key, Fieldsets.Builder __value) {
                    this.fieldsets.put(__key, __value);
                    return this;
                }

                public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
                    this.fieldsets.putAll(__values);
                    return this;
                }

                public Builder importedfield(Importedfield.Builder __builder) {
                    this.importedfield.add(__builder);
                    return this;
                }

                public Builder importedfield(List<Importedfield.Builder> __builders) {
                    this.importedfield = __builders;
                    return this;
                }

                public Documenttype build() {
                    return new Documenttype(this);
                }
            }
        }

        public static final class Annotationreftype
        extends InnerNode {
            private final StringNode annotation;

            public Annotationreftype(Builder builder) {
                this(builder, true);
            }

            private Annotationreftype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].annotationreftype[] must be initialized: " + builder.__uninitialized);
                }
                this.annotation = builder.annotation == null ? new StringNode() : new StringNode(builder.annotation);
            }

            public String annotation() {
                return this.annotation.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Annotationreftype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationreftype");
                return changes;
            }

            private static InnerNodeVector<Annotationreftype> createVector(List<Builder> builders) {
                ArrayList<Annotationreftype> elems = new ArrayList<Annotationreftype>();
                for (Builder b : builders) {
                    elems.add(new Annotationreftype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("annotation"));
                private String annotation = null;

                public Builder() {
                }

                public Builder(Annotationreftype config) {
                    this.annotation(config.annotation());
                }

                private Builder override(Builder __superior) {
                    if (__superior.annotation != null) {
                        this.annotation(__superior.annotation);
                    }
                    return this;
                }

                public Builder annotation(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.annotation = __value;
                    this.__uninitialized.remove("annotation");
                    return this;
                }

                public Annotationreftype build() {
                    return new Annotationreftype(this);
                }
            }
        }

        public static final class Structtype
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode version;
            private final Compresstype compresstype;
            private final IntegerNode compresslevel;
            private final IntegerNode compressthreshold;
            private final IntegerNode compressminsize;
            private final InnerNodeVector<Field> field;
            private final InnerNodeVector<Inherits> inherits;

            public Structtype(Builder builder) {
                this(builder, true);
            }

            private Structtype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                this.compresstype = builder.compresstype == null ? new Compresstype(Compresstype.NONE) : new Compresstype(builder.compresstype);
                this.compresslevel = builder.compresslevel == null ? new IntegerNode(0) : new IntegerNode(builder.compresslevel.intValue());
                this.compressthreshold = builder.compressthreshold == null ? new IntegerNode(95) : new IntegerNode(builder.compressthreshold.intValue());
                this.compressminsize = builder.compressminsize == null ? new IntegerNode(800) : new IntegerNode(builder.compressminsize.intValue());
                this.field = Field.createVector(builder.field);
                this.inherits = Inherits.createVector(builder.inherits);
            }

            public String name() {
                return this.name.value();
            }

            public int version() {
                return this.version.value();
            }

            public Compresstype.Enum compresstype() {
                return (Compresstype.Enum)((Object)this.compresstype.value());
            }

            public int compresslevel() {
                return this.compresslevel.value();
            }

            public int compressthreshold() {
                return this.compressthreshold.value();
            }

            public int compressminsize() {
                return this.compressminsize.value();
            }

            public List<Field> field() {
                return this.field;
            }

            public Field field(int i) {
                return (Field)((Object)this.field.get(i));
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
                return changes;
            }

            private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
                ArrayList<Structtype> elems = new ArrayList<Structtype>();
                for (Builder b : builders) {
                    elems.add(new Structtype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Inherits
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode version;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].inherits[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                }

                public String name() {
                    return this.name.value();
                }

                public int version() {
                    return this.version.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                    private String name = null;
                    private Integer version = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.name(config.name());
                        this.version(config.version());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.version != null) {
                            this.version(__superior.version);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder version(int __value) {
                        this.version = __value;
                        return this;
                    }

                    private Builder version(String __value) {
                        return this.version(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }

            public static final class Field
            extends InnerNode {
                private final StringNode name;
                private final InnerNodeVector<Id> id;
                private final IntegerNode datatype;
                private final StringNode detailedtype;

                public Field(Builder builder) {
                    this(builder, true);
                }

                private Field(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].field[] must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.id = Id.createVector(builder.id);
                    this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
                    this.detailedtype = builder.detailedtype == null ? new StringNode(DocumentmanagerConfig.CONFIG_DEF_VERSION) : new StringNode(builder.detailedtype);
                }

                public String name() {
                    return this.name.value();
                }

                public List<Id> id() {
                    return this.id;
                }

                public Id id(int i) {
                    return (Id)((Object)this.id.get(i));
                }

                public int datatype() {
                    return this.datatype.value();
                }

                public String detailedtype() {
                    return this.detailedtype.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                    return changes;
                }

                private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                    ArrayList<Field> elems = new ArrayList<Field>();
                    for (Builder b : builders) {
                        elems.add(new Field(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Id
                extends InnerNode {
                    private final IntegerNode id;

                    public Id(Builder builder) {
                        this(builder, true);
                    }

                    private Id(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].field[].id[] must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Id newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("id");
                        return changes;
                    }

                    private static InnerNodeVector<Id> createVector(List<Builder> builders) {
                        ArrayList<Id> elems = new ArrayList<Id>();
                        for (Builder b : builders) {
                            elems.add(new Id(b));
                        }
                        return new InnerNodeVector(elems);
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Id config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            this.__uninitialized.remove("id");
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }

                        public Id build() {
                            return new Id(this);
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "datatype"));
                    private String name = null;
                    public List<Id.Builder> id = new ArrayList<Id.Builder>();
                    private Integer datatype = null;
                    private String detailedtype = null;

                    public Builder() {
                    }

                    public Builder(Field config) {
                        this.name(config.name());
                        for (Id i : config.id()) {
                            this.id(new Id.Builder(i));
                        }
                        this.datatype(config.datatype());
                        this.detailedtype(config.detailedtype());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (!__superior.id.isEmpty()) {
                            this.id.addAll(__superior.id);
                        }
                        if (__superior.datatype != null) {
                            this.datatype(__superior.datatype);
                        }
                        if (__superior.detailedtype != null) {
                            this.detailedtype(__superior.detailedtype);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder id(Id.Builder __builder) {
                        this.id.add(__builder);
                        return this;
                    }

                    public Builder id(List<Id.Builder> __builders) {
                        this.id = __builders;
                        return this;
                    }

                    public Builder datatype(int __value) {
                        this.datatype = __value;
                        this.__uninitialized.remove("datatype");
                        return this;
                    }

                    private Builder datatype(String __value) {
                        return this.datatype(Integer.valueOf(__value));
                    }

                    public Builder detailedtype(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.detailedtype = __value;
                        return this;
                    }

                    public Field build() {
                        return new Field(this);
                    }
                }
            }

            public static final class Compresstype
            extends EnumNode<Enum> {
                public static final Enum NONE = Enum.NONE;
                public static final Enum UNCOMPRESSABLE = Enum.UNCOMPRESSABLE;
                public static final Enum LZ4 = Enum.LZ4;

                public Compresstype() {
                    this.value = null;
                }

                public Compresstype(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NONE,
                    UNCOMPRESSABLE,
                    LZ4;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                private String name = null;
                private Integer version = null;
                private Compresstype.Enum compresstype = null;
                private Integer compresslevel = null;
                private Integer compressthreshold = null;
                private Integer compressminsize = null;
                public List<Field.Builder> field = new ArrayList<Field.Builder>();
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

                public Builder() {
                }

                public Builder(Structtype config) {
                    this.name(config.name());
                    this.version(config.version());
                    this.compresstype(config.compresstype());
                    this.compresslevel(config.compresslevel());
                    this.compressthreshold(config.compressthreshold());
                    this.compressminsize(config.compressminsize());
                    for (Field f : config.field()) {
                        this.field(new Field.Builder(f));
                    }
                    for (Inherits i : config.inherits()) {
                        this.inherits(new Inherits.Builder(i));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.version != null) {
                        this.version(__superior.version);
                    }
                    if (__superior.compresstype != null) {
                        this.compresstype(__superior.compresstype);
                    }
                    if (__superior.compresslevel != null) {
                        this.compresslevel(__superior.compresslevel);
                    }
                    if (__superior.compressthreshold != null) {
                        this.compressthreshold(__superior.compressthreshold);
                    }
                    if (__superior.compressminsize != null) {
                        this.compressminsize(__superior.compressminsize);
                    }
                    if (!__superior.field.isEmpty()) {
                        this.field.addAll(__superior.field);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder version(int __value) {
                    this.version = __value;
                    return this;
                }

                private Builder version(String __value) {
                    return this.version(Integer.valueOf(__value));
                }

                public Builder compresstype(Compresstype.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.compresstype = __value;
                    return this;
                }

                private Builder compresstype(String __value) {
                    return this.compresstype(Compresstype.Enum.valueOf(__value));
                }

                public Builder compresslevel(int __value) {
                    this.compresslevel = __value;
                    return this;
                }

                private Builder compresslevel(String __value) {
                    return this.compresslevel(Integer.valueOf(__value));
                }

                public Builder compressthreshold(int __value) {
                    this.compressthreshold = __value;
                    return this;
                }

                private Builder compressthreshold(String __value) {
                    return this.compressthreshold(Integer.valueOf(__value));
                }

                public Builder compressminsize(int __value) {
                    this.compressminsize = __value;
                    return this;
                }

                private Builder compressminsize(String __value) {
                    return this.compressminsize(Integer.valueOf(__value));
                }

                public Builder field(Field.Builder __builder) {
                    this.field.add(__builder);
                    return this;
                }

                public Builder field(List<Field.Builder> __builders) {
                    this.field = __builders;
                    return this;
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Structtype build() {
                    return new Structtype(this);
                }
            }
        }

        public static final class Weightedsettype
        extends InnerNode {
            private final IntegerNode datatype;
            private final BooleanNode createifnonexistant;
            private final BooleanNode removeifzero;

            public Weightedsettype(Builder builder) {
                this(builder, true);
            }

            private Weightedsettype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].weightedsettype[] must be initialized: " + builder.__uninitialized);
                }
                this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
                this.createifnonexistant = builder.createifnonexistant == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistant.booleanValue());
                this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
            }

            public int datatype() {
                return this.datatype.value();
            }

            public boolean createifnonexistant() {
                return this.createifnonexistant.value();
            }

            public boolean removeifzero() {
                return this.removeifzero.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Weightedsettype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("weightedsettype");
                return changes;
            }

            private static InnerNodeVector<Weightedsettype> createVector(List<Builder> builders) {
                ArrayList<Weightedsettype> elems = new ArrayList<Weightedsettype>();
                for (Builder b : builders) {
                    elems.add(new Weightedsettype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("datatype"));
                private Integer datatype = null;
                private Boolean createifnonexistant = null;
                private Boolean removeifzero = null;

                public Builder() {
                }

                public Builder(Weightedsettype config) {
                    this.datatype(config.datatype());
                    this.createifnonexistant(config.createifnonexistant());
                    this.removeifzero(config.removeifzero());
                }

                private Builder override(Builder __superior) {
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    if (__superior.createifnonexistant != null) {
                        this.createifnonexistant(__superior.createifnonexistant);
                    }
                    if (__superior.removeifzero != null) {
                        this.removeifzero(__superior.removeifzero);
                    }
                    return this;
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    this.__uninitialized.remove("datatype");
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Builder createifnonexistant(boolean __value) {
                    this.createifnonexistant = __value;
                    return this;
                }

                private Builder createifnonexistant(String __value) {
                    return this.createifnonexistant(Boolean.valueOf(__value));
                }

                public Builder removeifzero(boolean __value) {
                    this.removeifzero = __value;
                    return this;
                }

                private Builder removeifzero(String __value) {
                    return this.removeifzero(Boolean.valueOf(__value));
                }

                public Weightedsettype build() {
                    return new Weightedsettype(this);
                }
            }
        }

        public static final class Maptype
        extends InnerNode {
            private final IntegerNode keytype;
            private final IntegerNode valtype;

            public Maptype(Builder builder) {
                this(builder, true);
            }

            private Maptype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].maptype[] must be initialized: " + builder.__uninitialized);
                }
                this.keytype = builder.keytype == null ? new IntegerNode() : new IntegerNode(builder.keytype.intValue());
                this.valtype = builder.valtype == null ? new IntegerNode() : new IntegerNode(builder.valtype.intValue());
            }

            public int keytype() {
                return this.keytype.value();
            }

            public int valtype() {
                return this.valtype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
                return changes;
            }

            private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
                ArrayList<Maptype> elems = new ArrayList<Maptype>();
                for (Builder b : builders) {
                    elems.add(new Maptype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("keytype", "valtype"));
                private Integer keytype = null;
                private Integer valtype = null;

                public Builder() {
                }

                public Builder(Maptype config) {
                    this.keytype(config.keytype());
                    this.valtype(config.valtype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.keytype != null) {
                        this.keytype(__superior.keytype);
                    }
                    if (__superior.valtype != null) {
                        this.valtype(__superior.valtype);
                    }
                    return this;
                }

                public Builder keytype(int __value) {
                    this.keytype = __value;
                    this.__uninitialized.remove("keytype");
                    return this;
                }

                private Builder keytype(String __value) {
                    return this.keytype(Integer.valueOf(__value));
                }

                public Builder valtype(int __value) {
                    this.valtype = __value;
                    this.__uninitialized.remove("valtype");
                    return this;
                }

                private Builder valtype(String __value) {
                    return this.valtype(Integer.valueOf(__value));
                }

                public Maptype build() {
                    return new Maptype(this);
                }
            }
        }

        public static final class Arraytype
        extends InnerNode {
            private final IntegerNode datatype;

            public Arraytype(Builder builder) {
                this(builder, true);
            }

            private Arraytype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].arraytype[] must be initialized: " + builder.__uninitialized);
                }
                this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
            }

            public int datatype() {
                return this.datatype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
                return changes;
            }

            private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
                ArrayList<Arraytype> elems = new ArrayList<Arraytype>();
                for (Builder b : builders) {
                    elems.add(new Arraytype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("datatype"));
                private Integer datatype = null;

                public Builder() {
                }

                public Builder(Arraytype config) {
                    this.datatype(config.datatype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    return this;
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    this.__uninitialized.remove("datatype");
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Arraytype build() {
                    return new Arraytype(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
            private Integer id = null;
            public List<Arraytype.Builder> arraytype = new ArrayList<Arraytype.Builder>();
            public List<Maptype.Builder> maptype = new ArrayList<Maptype.Builder>();
            public List<Weightedsettype.Builder> weightedsettype = new ArrayList<Weightedsettype.Builder>();
            public List<Structtype.Builder> structtype = new ArrayList<Structtype.Builder>();
            public List<Annotationreftype.Builder> annotationreftype = new ArrayList<Annotationreftype.Builder>();
            public List<Documenttype.Builder> documenttype = new ArrayList<Documenttype.Builder>();
            public List<Referencetype.Builder> referencetype = new ArrayList<Referencetype.Builder>();

            public Builder() {
            }

            public Builder(Datatype config) {
                this.id(config.id());
                for (Arraytype arraytype : config.arraytype()) {
                    this.arraytype(new Arraytype.Builder(arraytype));
                }
                for (Maptype maptype : config.maptype()) {
                    this.maptype(new Maptype.Builder(maptype));
                }
                for (Weightedsettype weightedsettype : config.weightedsettype()) {
                    this.weightedsettype(new Weightedsettype.Builder(weightedsettype));
                }
                for (Structtype structtype : config.structtype()) {
                    this.structtype(new Structtype.Builder(structtype));
                }
                for (Annotationreftype annotationreftype : config.annotationreftype()) {
                    this.annotationreftype(new Annotationreftype.Builder(annotationreftype));
                }
                for (Documenttype documenttype : config.documenttype()) {
                    this.documenttype(new Documenttype.Builder(documenttype));
                }
                for (Referencetype referencetype : config.referencetype()) {
                    this.referencetype(new Referencetype.Builder(referencetype));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (!__superior.arraytype.isEmpty()) {
                    this.arraytype.addAll(__superior.arraytype);
                }
                if (!__superior.maptype.isEmpty()) {
                    this.maptype.addAll(__superior.maptype);
                }
                if (!__superior.weightedsettype.isEmpty()) {
                    this.weightedsettype.addAll(__superior.weightedsettype);
                }
                if (!__superior.structtype.isEmpty()) {
                    this.structtype.addAll(__superior.structtype);
                }
                if (!__superior.annotationreftype.isEmpty()) {
                    this.annotationreftype.addAll(__superior.annotationreftype);
                }
                if (!__superior.documenttype.isEmpty()) {
                    this.documenttype.addAll(__superior.documenttype);
                }
                if (!__superior.referencetype.isEmpty()) {
                    this.referencetype.addAll(__superior.referencetype);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder arraytype(Arraytype.Builder __builder) {
                this.arraytype.add(__builder);
                return this;
            }

            public Builder arraytype(List<Arraytype.Builder> __builders) {
                this.arraytype = __builders;
                return this;
            }

            public Builder maptype(Maptype.Builder __builder) {
                this.maptype.add(__builder);
                return this;
            }

            public Builder maptype(List<Maptype.Builder> __builders) {
                this.maptype = __builders;
                return this;
            }

            public Builder weightedsettype(Weightedsettype.Builder __builder) {
                this.weightedsettype.add(__builder);
                return this;
            }

            public Builder weightedsettype(List<Weightedsettype.Builder> __builders) {
                this.weightedsettype = __builders;
                return this;
            }

            public Builder structtype(Structtype.Builder __builder) {
                this.structtype.add(__builder);
                return this;
            }

            public Builder structtype(List<Structtype.Builder> __builders) {
                this.structtype = __builders;
                return this;
            }

            public Builder annotationreftype(Annotationreftype.Builder __builder) {
                this.annotationreftype.add(__builder);
                return this;
            }

            public Builder annotationreftype(List<Annotationreftype.Builder> __builders) {
                this.annotationreftype = __builders;
                return this;
            }

            public Builder documenttype(Documenttype.Builder __builder) {
                this.documenttype.add(__builder);
                return this;
            }

            public Builder documenttype(List<Documenttype.Builder> __builders) {
                this.documenttype = __builders;
                return this;
            }

            public Builder referencetype(Referencetype.Builder __builder) {
                this.referencetype.add(__builder);
                return this;
            }

            public Builder referencetype(List<Referencetype.Builder> __builders) {
                this.referencetype = __builders;
                return this;
            }

            public Datatype build() {
                return new Datatype(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean enablecompression = null;
        public List<Datatype.Builder> datatype = new ArrayList<Datatype.Builder>();
        public List<Annotationtype.Builder> annotationtype = new ArrayList<Annotationtype.Builder>();

        public Builder() {
        }

        public Builder(DocumentmanagerConfig config) {
            this.enablecompression(config.enablecompression());
            for (Datatype d : config.datatype()) {
                this.datatype(new Datatype.Builder(d));
            }
            for (Annotationtype a : config.annotationtype()) {
                this.annotationtype(new Annotationtype.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.enablecompression != null) {
                this.enablecompression(__superior.enablecompression);
            }
            if (!__superior.datatype.isEmpty()) {
                this.datatype.addAll(__superior.datatype);
            }
            if (!__superior.annotationtype.isEmpty()) {
                this.annotationtype.addAll(__superior.annotationtype);
            }
            return this;
        }

        public Builder enablecompression(boolean __value) {
            this.enablecompression = __value;
            return this;
        }

        private Builder enablecompression(String __value) {
            return this.enablecompression(Boolean.valueOf(__value));
        }

        public Builder datatype(Datatype.Builder __builder) {
            this.datatype.add(__builder);
            return this;
        }

        public Builder datatype(List<Datatype.Builder> __builders) {
            this.datatype = __builders;
            return this;
        }

        public Builder annotationtype(Annotationtype.Builder __builder) {
            this.annotationtype.add(__builder);
            return this;
        }

        public Builder annotationtype(List<Annotationtype.Builder> __builders) {
            this.annotationtype = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DocumentmanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DocumentmanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DocumentmanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public DocumentmanagerConfig build() {
            return new DocumentmanagerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

