/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public final class LongFieldValue
extends NumericFieldValue {
    public static final int classId = LongFieldValue.registerClass((int)4108, LongFieldValue.class);
    private long value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public LongFieldValue() {
        this(0L);
    }

    public LongFieldValue(long value) {
        this.value = value;
    }

    public LongFieldValue(Long value) {
        this.value = value;
    }

    public LongFieldValue(String s) {
        this.value = Long.parseLong(s);
    }

    @Override
    public LongFieldValue clone() {
        LongFieldValue val = (LongFieldValue)super.clone();
        val.value = this.value;
        return val;
    }

    @Override
    public void clear() {
        this.value = 0L;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public void assign(Object obj) {
        if (!this.checkAssign(obj)) {
            return;
        }
        if (obj instanceof Number) {
            this.value = ((Number)obj).longValue();
        } else if (obj instanceof NumericFieldValue) {
            this.value = ((NumericFieldValue)obj).getNumber().longValue();
        } else if (obj instanceof String || obj instanceof StringFieldValue) {
            this.value = Long.parseLong(obj.toString());
        } else {
            throw new IllegalArgumentException("Class " + obj.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public long getLong() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public DataType getDataType() {
        return DataType.LONG;
    }

    @Override
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printLongXml(this, xml);
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongFieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongFieldValue that = (LongFieldValue)o;
        return this.value == that.value;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        LongFieldValue otherValue = (LongFieldValue)fieldValue;
        if (this.value < otherValue.value) {
            return -1;
        }
        if (this.value > otherValue.value) {
            return 1;
        }
        return 0;
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new LongFieldValue();
        }
    }
}

