/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.TensorReader;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorAddUpdateReader {
    public static boolean isTensorField(Field field) {
        return field.getDataType() instanceof TensorDataType;
    }

    public static TensorAddUpdate createTensorAddUpdate(TokenBuffer buffer, Field field) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorAddUpdateReader.expectTensorTypeIsSparse(field);
        TensorDataType tensorDataType = (TensorDataType)field.getDataType();
        TensorType tensorType = tensorDataType.getTensorType();
        TensorFieldValue tensorFieldValue = new TensorFieldValue(tensorType);
        TensorReader.fillTensor(buffer, tensorFieldValue);
        TensorAddUpdateReader.expectTensorIsNonEmpty(field, tensorFieldValue.getTensor().get());
        return new TensorAddUpdate(tensorFieldValue);
    }

    private static void expectTensorTypeIsSparse(Field field) {
        TensorType tensorType = ((TensorDataType)field.getDataType()).getTensorType();
        if (tensorType.dimensions().stream().anyMatch(dim -> dim.isIndexed())) {
            throw new IllegalArgumentException("An add update can only be applied to sparse tensors. Field '" + field.getName() + "' has unsupported tensor type '" + tensorType + "'");
        }
    }

    private static void expectTensorIsNonEmpty(Field field, Tensor tensor) {
        if (tensor.isEmpty()) {
            throw new IllegalArgumentException("Add update for field '" + field.getName() + "' does not contain tensor cells");
        }
    }
}

