/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.google.inject.Inject;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TemporaryDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationTypeRegistry;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.TensorType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DocumentTypeManager {
    private static final Logger log = Logger.getLogger(DocumentTypeManager.class.getName());
    private ConfigSubscriber subscriber;
    private Map<Integer, DataType> dataTypes = new LinkedHashMap<Integer, DataType>();
    private Map<DataTypeName, DocumentType> documentTypes = new LinkedHashMap<DataTypeName, DocumentType>();
    private AnnotationTypeRegistry annotationTypeRegistry = new AnnotationTypeRegistry();

    public DocumentTypeManager() {
        this.registerDefaultDataTypes();
    }

    @Inject
    public DocumentTypeManager(DocumentmanagerConfig config) {
        this();
        DocumentTypeManagerConfigurer.configureNewManager(config, this);
    }

    public void assign(DocumentTypeManager other) {
        this.dataTypes = other.dataTypes;
        this.documentTypes = other.documentTypes;
        this.annotationTypeRegistry = other.annotationTypeRegistry;
    }

    public DocumentTypeManager configure(String configId) {
        this.subscriber = DocumentTypeManagerConfigurer.configure(this, configId);
        return this;
    }

    private void registerDefaultDataTypes() {
        DocumentType superDocType = DataType.DOCUMENT;
        this.dataTypes.put(superDocType.getId(), superDocType);
        this.documentTypes.put(superDocType.getDataTypeName(), superDocType);
        Class<DataType> dataTypeClass = DataType.class;
        for (java.lang.reflect.Field field : dataTypeClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !DataType.class.isAssignableFrom(field.getType())) continue;
            try {
                DataType type = (DataType)field.get(null);
                this.register(type);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AnnotationType type : AnnotationTypes.ALL_TYPES) {
            this.annotationTypeRegistry.register(type);
        }
    }

    public boolean hasDataType(String name) {
        if (name.startsWith("tensor(")) {
            return true;
        }
        for (DataType type : this.dataTypes.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDataType(int code) {
        if (code == 21) {
            return true;
        }
        return this.dataTypes.containsKey(code);
    }

    public DataType getDataType(String name) {
        if (name.startsWith("tensor(")) {
            return new TensorDataType(TensorType.fromSpec((String)name));
        }
        ArrayList<DataType> foundTypes = new ArrayList<DataType>();
        for (DataType type : this.dataTypes.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            foundTypes.add(type);
        }
        if (foundTypes.isEmpty()) {
            throw new IllegalArgumentException("No datatype named " + name);
        }
        if (foundTypes.size() == 1) {
            return (DataType)foundTypes.get(0);
        }
        Collections.sort(foundTypes, new Comparator<DataType>(){

            @Override
            public int compare(DataType first, DataType second) {
                if (first instanceof StructuredDataType && !(second instanceof StructuredDataType)) {
                    return 1;
                }
                if (!(first instanceof StructuredDataType) && second instanceof StructuredDataType) {
                    return -1;
                }
                return 0;
            }
        });
        return (DataType)foundTypes.get(0);
    }

    public DataType getDataType(int code) {
        return this.getDataType(code, "");
    }

    public DataType getDataType(int code, String detailedType) {
        if (code == 21) {
            return new TensorDataType(TensorType.fromSpec((String)detailedType));
        }
        DataType type = this.dataTypes.get(code);
        if (type == null) {
            StringBuilder types = new StringBuilder();
            for (Integer key : this.dataTypes.keySet()) {
                types.append(key).append(" ");
            }
            throw new IllegalArgumentException("No datatype with code " + code + ". Registered type ids: " + types);
        }
        return type;
    }

    DataType getDataTypeAndReturnTemporary(int code, String detailedType) {
        if (this.hasDataType(code)) {
            return this.getDataType(code, detailedType);
        }
        return new TemporaryDataType(code, detailedType);
    }

    public void register(DataType type) {
        type.register(this);
    }

    void registerSingleType(DataType type) {
        if (type instanceof TensorDataType) {
            return;
        }
        if (this.dataTypes.containsKey(type.getId())) {
            DataType existingType = this.dataTypes.get(type.getId());
            if ((type instanceof TemporaryDataType || type instanceof TemporaryStructuredDataType) && !(existingType instanceof TemporaryDataType) && !(existingType instanceof TemporaryStructuredDataType)) {
                return;
            }
            if (!(existingType != type && !existingType.equals(type) || existingType instanceof TemporaryDataType || type instanceof TemporaryDataType || existingType instanceof TemporaryStructuredDataType || type instanceof TemporaryStructuredDataType)) {
                return;
            }
            if (type instanceof DocumentType && this.dataTypes.get(type.getId()) instanceof DocumentType) {
                log.warning("Document type " + existingType + " is not equal to document type attempted registered " + type + ", but have same name. OVERWRITING TYPE as many tests currently does this. Fix tests so we can throw exception here.");
            } else if (existingType instanceof TemporaryDataType || existingType instanceof TemporaryStructuredDataType) {
                this.dataTypes.remove(existingType.getId());
            } else {
                throw new IllegalStateException("Datatype " + existingType + " is not equal to datatype attempted registered " + type + ", but already uses id " + type.getId());
            }
        }
        if (type instanceof DocumentType) {
            DocumentType docType = (DocumentType)type;
            if (docType.getInheritedTypes().size() == 0) {
                docType.inherit(this.documentTypes.get(new DataTypeName("document")));
            }
            this.documentTypes.put(docType.getDataTypeName(), docType);
        }
        this.dataTypes.put(type.getId(), type);
        type.setRegistered();
    }

    public DocumentType registerDocumentType(DocumentType docType) {
        this.register(docType);
        return docType;
    }

    public DocumentType getDocumentType(DataTypeName name) {
        return this.documentTypes.get(name);
    }

    public DocumentType getDocumentType(String name) {
        return this.documentTypes.get(new DataTypeName(name));
    }

    public final Document createDocument(GrowableByteBuffer buf) {
        DocumentDeserializer data = DocumentDeserializerFactory.create42(this, buf);
        return new Document(data);
    }

    public Document createDocument(DocumentDeserializer data) {
        return new Document(data);
    }

    public Document createDocument(GrowableByteBuffer header, GrowableByteBuffer body) {
        DocumentDeserializer data = DocumentDeserializerFactory.create42(this, header, body);
        return new Document(data);
    }

    public Collection<DataType> getDataTypes() {
        return Collections.unmodifiableCollection(this.dataTypes.values());
    }

    public Map<DataTypeName, DocumentType> getDocumentTypes() {
        return Collections.unmodifiableMap(this.documentTypes);
    }

    public Iterator<DocumentType> documentTypeIterator() {
        return this.documentTypes.values().iterator();
    }

    public void clear() {
        this.documentTypes.clear();
        this.dataTypes.clear();
        this.registerDefaultDataTypes();
    }

    public AnnotationTypeRegistry getAnnotationTypeRegistry() {
        return this.annotationTypeRegistry;
    }

    void replaceTemporaryTypes() {
        for (DataType type : this.dataTypes.values()) {
            LinkedList<DataType> seenStructs = new LinkedList<DataType>();
            this.replaceTemporaryTypes(type, seenStructs);
        }
    }

    private void replaceTemporaryTypes(DataType type, List<DataType> seenStructs) {
        if (type instanceof WeightedSetDataType) {
            this.replaceTemporaryTypesInWeightedSet((WeightedSetDataType)type, seenStructs);
        } else if (type instanceof MapDataType) {
            this.replaceTemporaryTypesInMap((MapDataType)type, seenStructs);
        } else if (type instanceof CollectionDataType) {
            this.replaceTemporaryTypesInCollection((CollectionDataType)type, seenStructs);
        } else if (type instanceof StructDataType) {
            this.replaceTemporaryTypesInStruct((StructDataType)type, seenStructs);
        } else if (!(type instanceof PrimitiveDataType || type instanceof AnnotationReferenceDataType || type instanceof DocumentType || type instanceof TensorDataType)) {
            if (type instanceof ReferenceDataType) {
                this.replaceTemporaryTypeInReference((ReferenceDataType)type);
            } else {
                if (type instanceof TemporaryDataType) {
                    throw new IllegalStateException("TemporaryDataType registered in DocumentTypeManager, BUG!!");
                }
                log.warning("Don't know how to replace temporary data types in " + type);
            }
        }
    }

    private void replaceTemporaryTypesInStruct(StructDataType structDataType, List<DataType> seenStructs) {
        seenStructs.add(structDataType);
        for (Field field : structDataType.getFieldsThisTypeOnly()) {
            DataType fieldType = field.getDataType();
            if (fieldType instanceof TemporaryDataType) {
                field.setDataType(this.getDataType(fieldType.getCode(), ((TemporaryDataType)fieldType).getDetailedType()));
                continue;
            }
            if (seenStructs.contains(fieldType)) continue;
            this.replaceTemporaryTypes(fieldType, seenStructs);
        }
    }

    private void replaceTemporaryTypeInReference(ReferenceDataType referenceDataType) {
        if (referenceDataType.getTargetType() instanceof TemporaryStructuredDataType) {
            referenceDataType.setTargetType((DocumentType)this.getDataType(referenceDataType.getTargetType().getId()));
        }
    }

    private void replaceTemporaryTypesInCollection(CollectionDataType collectionDataType, List<DataType> seenStructs) {
        if (collectionDataType.getNestedType() instanceof TemporaryDataType) {
            collectionDataType.setNestedType(this.getDataType(collectionDataType.getNestedType().getCode(), ""));
        } else {
            this.replaceTemporaryTypes(collectionDataType.getNestedType(), seenStructs);
        }
    }

    private void replaceTemporaryTypesInMap(MapDataType mapDataType, List<DataType> seenStructs) {
        if (mapDataType.getValueType() instanceof TemporaryDataType) {
            mapDataType.setValueType(this.getDataType(mapDataType.getValueType().getCode(), ""));
        } else {
            this.replaceTemporaryTypes(mapDataType.getValueType(), seenStructs);
        }
        if (mapDataType.getKeyType() instanceof TemporaryDataType) {
            mapDataType.setKeyType(this.getDataType(mapDataType.getKeyType().getCode(), ""));
        } else {
            this.replaceTemporaryTypes(mapDataType.getKeyType(), seenStructs);
        }
    }

    private void replaceTemporaryTypesInWeightedSet(WeightedSetDataType weightedSetDataType, List<DataType> seenStructs) {
        if (weightedSetDataType.getNestedType() instanceof TemporaryDataType) {
            weightedSetDataType.setNestedType(this.getDataType(weightedSetDataType.getNestedType().getCode(), ""));
        } else {
            this.replaceTemporaryTypes(weightedSetDataType.getNestedType(), seenStructs);
        }
    }

    public void shutdown() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

