/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.datatypes.CompositeFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import java.util.Collection;
import java.util.Iterator;

public abstract class CollectionFieldValue<T extends FieldValue>
extends CompositeFieldValue {
    CollectionFieldValue(CollectionDataType type) {
        super(type);
    }

    @Override
    public CollectionDataType getDataType() {
        return (CollectionDataType)super.getDataType();
    }

    protected FieldValue createFieldValue(Object o) {
        if (o instanceof FieldValue) {
            if (!this.getDataType().getNestedType().isValueCompatible((FieldValue)o)) {
                throw new IllegalArgumentException("Incompatible data types. Got " + ((FieldValue)o).getDataType() + ", expected " + this.getDataType().getNestedType());
            }
            return (FieldValue)o;
        }
        FieldValue fval = this.getDataType().getNestedType().createFieldValue();
        fval.assign(o);
        return fval;
    }

    public void verifyElementCompatibility(T o) {
        if (!this.getDataType().getNestedType().isValueCompatible((FieldValue)o)) {
            throw new IllegalArgumentException("Incompatible data types. Got " + ((FieldValue)o).getDataType() + ", expected " + this.getDataType().getNestedType());
        }
    }

    public abstract Iterator<T> fieldValueIterator();

    public abstract boolean add(T var1);

    public abstract boolean contains(Object var1);

    public abstract boolean isEmpty();

    protected boolean isEmpty(Collection collection) {
        return collection.isEmpty();
    }

    public abstract Iterator<T> iterator();

    public abstract boolean removeValue(FieldValue var1);

    protected boolean removeValue(FieldValue o, Collection collection) {
        int removedCount = 0;
        while (collection.remove(o)) {
            ++removedCount;
        }
        return removedCount > 0;
    }

    public abstract int size();
}

