/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.document.CompressionConfig;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseStructDataType
extends StructuredDataType {
    protected Map<Integer, Field> fieldIds = new LinkedHashMap<Integer, Field>();
    protected Map<Integer, Field> fieldIdsV6 = new LinkedHashMap<Integer, Field>();
    protected Map<String, Field> fields = new LinkedHashMap<String, Field>();
    protected Compressor compressor = new Compressor(CompressionType.NONE);

    BaseStructDataType(String name) {
        super(name);
    }

    BaseStructDataType(int id, String name) {
        super(id, name);
    }

    protected void assign(BaseStructDataType type) {
        BaseStructDataType stype = type.clone();
        this.fieldIds = stype.fieldIds;
        this.fieldIdsV6 = stype.fieldIdsV6;
        this.fields = stype.fields;
    }

    @Override
    public BaseStructDataType clone() {
        BaseStructDataType type = (BaseStructDataType)super.clone();
        type.fieldIds = new LinkedHashMap<Integer, Field>();
        type.fieldIdsV6 = new LinkedHashMap<Integer, Field>();
        type.fields = new LinkedHashMap<String, Field>();
        for (Field field : this.fieldIds.values()) {
            type.fields.put(field.getName(), field);
            type.fieldIds.put(field.getId(8), field);
            type.fieldIdsV6.put(field.getId(6), field);
        }
        return type;
    }

    public void addField(Field field) {
        if (this.fields.containsKey(field.getName())) {
            throw new IllegalArgumentException("Struct " + this.getName() + " already contains field with name " + field.getName());
        }
        if (this.fieldIds.containsKey(field.getId(8))) {
            throw new IllegalArgumentException("Struct " + this.getName() + " already contains field with id " + field.getId(8));
        }
        if (this.fieldIdsV6.containsKey(field.getId(6))) {
            throw new IllegalArgumentException("Struct " + this.getName() + " already contains a field with deprecated document serialization id " + field.getId(6));
        }
        this.fields.put(field.getName(), field);
        this.fieldIds.put(field.getId(8), field);
        this.fieldIdsV6.put(field.getId(6), field);
    }

    public Field removeField(String fieldName) {
        Field old = this.fields.remove(fieldName);
        if (old != null) {
            this.fieldIds.remove(old.getId(8));
            this.fieldIdsV6.remove(old.getId(6));
        }
        return old;
    }

    public void clearFields() {
        this.fieldIds.clear();
        this.fieldIdsV6.clear();
        this.fields.clear();
    }

    public Field getField(Integer fieldId, int version) {
        if (version > 6) {
            return this.fieldIds.get(fieldId);
        }
        return this.fieldIdsV6.get(fieldId);
    }

    @Override
    public Field getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    public Field getField(int id) {
        return this.fieldIds.get(id);
    }

    public boolean hasField(Field field, int version) {
        Field f = this.getField(field.getId(version), version);
        return f != null && f.equals(field);
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public boolean hasField(Field f) {
        return this.hasField(f, 6) || this.hasField(f, 8);
    }

    @Override
    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public CompressionConfig getCompressionConfig() {
        float compressionThresholdPercentage = (float)this.compressor.compressionThresholdFactor() * 100.0f;
        return new CompressionConfig(this.compressor.type(), this.compressor.level(), compressionThresholdPercentage, this.compressor.compressMinSizeBytes());
    }

    public void setCompressionConfig(CompressionConfig config) {
        CompressionType type = config.type;
        this.compressor = new Compressor(type, config.compressionLevel, (double)config.thresholdFactor(), (int)config.minsize);
    }
}

